/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.StateCache;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class FileProcessingCompilerStateCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.FileProcessingCompilerStateCache");
    private final StateCache<MyState> myCache;

    public FileProcessingCompilerStateCache(File storeDirectory, final ValidityStateFactory stateFactory) throws IOException {
        this.myCache = new StateCache<MyState>(new File(storeDirectory, "timestamps")){

            @Override
            public MyState read(DataInput stream) throws IOException {
                return new MyState(stream.readLong(), stateFactory.createValidityState(stream));
            }

            @Override
            public void write(MyState state, DataOutput out) throws IOException {
                out.writeLong(state.getTimestamp());
                ValidityState extState = state.getExtState();
                if (extState != null) {
                    extState.save(out);
                }
            }
        };
    }

    public void update(VirtualFile sourceFile, ValidityState extState) throws IOException {
        if (sourceFile.isValid()) {
            this.myCache.update(sourceFile.getUrl(), new MyState(sourceFile.getTimeStamp(), extState));
        }
    }

    public void remove(String url) throws IOException {
        this.myCache.remove(url);
    }

    public long getTimestamp(String url) throws IOException {
        MyState state = this.myCache.getState(url);
        return state != null ? state.getTimestamp() : -1L;
    }

    public ValidityState getExtState(String url) throws IOException {
        MyState state = this.myCache.getState(url);
        return state != null ? state.getExtState() : null;
    }

    public void force() {
        this.myCache.force();
    }

    public Collection<String> getUrls() throws IOException {
        return this.myCache.getUrls();
    }

    public boolean wipe() {
        return this.myCache.wipe();
    }

    public void close() {
        try {
            this.myCache.close();
        }
        catch (IOException ignored) {
            LOG.info((Throwable)ignored);
        }
    }

    private static class MyState
    implements Serializable {
        private final long myTimestamp;
        private final ValidityState myExtState;

        public MyState(long timestamp, @Nullable ValidityState extState) {
            this.myTimestamp = timestamp;
            this.myExtState = extState;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        @Nullable
        public ValidityState getExtState() {
            return this.myExtState;
        }
    }
}

