/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

class ExcludeFromCompileAction
extends AnAction {
    private final Project myProject;
    private final NewErrorTreeViewPanel myErrorTreeView;

    public ExcludeFromCompileAction(Project project2, NewErrorTreeViewPanel errorTreeView) {
        super(CompilerBundle.message((String)"actions.exclude.from.compile.text", (Object[])new Object[0]));
        this.myProject = project2;
        this.myErrorTreeView = errorTreeView;
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile file = this.getSelectedFile();
        if (file != null && file.isValid()) {
            ExcludeEntryDescription description = new ExcludeEntryDescription(file, false, true, (Disposable)this.myProject);
            CompilerConfiguration.getInstance((Project)this.myProject).getExcludedEntriesConfiguration().addExcludeEntryDescription(description);
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
    }

    @Nullable
    private VirtualFile getSelectedFile() {
        NodeDescriptor parent;
        ErrorTreeElement element;
        ErrorTreeNodeDescriptor descriptor2 = this.myErrorTreeView.getSelectedNodeDescriptor();
        ErrorTreeElement errorTreeElement = element = descriptor2 != null ? descriptor2.getElement() : null;
        if (element != null && !(element instanceof GroupingElement) && (parent = descriptor2.getParentDescriptor()) instanceof ErrorTreeNodeDescriptor) {
            element = ((ErrorTreeNodeDescriptor)parent).getElement();
        }
        return element instanceof GroupingElement ? ((GroupingElement)element).getFile() : null;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean isApplicable = this.getSelectedFile() != null;
        presentation.setEnabled(isApplicable);
        presentation.setVisible(isApplicable);
    }
}

