/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.Queue;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.JavaCompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;
import org.jetbrains.jps.backwardRefs.index.JavaCompilerIndices;

public class JavaBackwardReferenceIndexReaderFactory
implements CompilerReferenceReaderFactory<BackwardReferenceReader> {
    public static final JavaBackwardReferenceIndexReaderFactory INSTANCE = new JavaBackwardReferenceIndexReaderFactory();
    private static final Logger LOG = Logger.getInstance(JavaBackwardReferenceIndexReaderFactory.class);

    @Override
    public int expectedIndexVersion() {
        return 7;
    }

    @Override
    @Nullable
    public BackwardReferenceReader create(Project project2) {
        File buildDir = BuildManager.getInstance().getProjectSystemDirectory(project2);
        if (buildDir == null || !CompilerReferenceIndex.exists((File)buildDir) || CompilerReferenceIndex.versionDiffers((File)buildDir, (int)this.expectedIndexVersion())) {
            return null;
        }
        try {
            return new BackwardReferenceReader(buildDir);
        }
        catch (RuntimeException e) {
            LOG.error("An exception while initialization of compiler reference index.", (Throwable)e);
            return null;
        }
    }

    public static class BackwardReferenceReader
    extends CompilerReferenceReader<JavaCompilerBackwardReferenceIndex> {
        protected BackwardReferenceReader(File buildDir) {
            super(buildDir, new JavaCompilerBackwardReferenceIndex(buildDir, true));
        }

        @Override
        @Nullable
        public TIntHashSet findReferentFileIds(@NotNull CompilerRef ref, boolean checkBaseClassAmbiguity) throws StorageException {
            CompilerRef.NamedCompilerRef[] hierarchy;
            if (ref == null) {
                BackwardReferenceReader.$$$reportNull$$$0(0);
            }
            if (ref instanceof CompilerRef.CompilerClassHierarchyElementDef) {
                hierarchy = new CompilerRef.NamedCompilerRef[]{(CompilerRef.NamedCompilerRef)ref};
            } else {
                CompilerRef.CompilerClassHierarchyElementDef hierarchyElement = ((CompilerRef.CompilerMember)ref).getOwner();
                hierarchy = this.getHierarchy(hierarchyElement, checkBaseClassAmbiguity, false, -1);
            }
            if (hierarchy == null) {
                return null;
            }
            TIntHashSet set = new TIntHashSet();
            for (CompilerRef.NamedCompilerRef aClass : hierarchy) {
                CompilerRef overriderUsage = ref.override(aClass.getName());
                this.addUsages(overriderUsage, set);
            }
            return set;
        }

        @Override
        @Nullable
        public TIntHashSet findFileIdsWithImplicitToString(@NotNull CompilerRef ref) throws StorageException {
            if (ref == null) {
                BackwardReferenceReader.$$$reportNull$$$0(1);
            }
            final TIntHashSet result = new TIntHashSet();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.IMPLICIT_TO_STRING).getData((Object)ref).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

                public boolean perform(int id, Void value) {
                    VirtualFile file = this.findFile(id);
                    if (file != null) {
                        result.add(((VirtualFileWithId)file).getId());
                    }
                    return true;
                }
            });
            return result;
        }

        @Override
        @NotNull
        public Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull CompilerRef searchElement, @NotNull GlobalSearchScope searchScope, @NotNull GlobalSearchScope dirtyScope, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType searchType) throws StorageException {
            if (searchElement == null) {
                BackwardReferenceReader.$$$reportNull$$$0(2);
            }
            if (searchScope == null) {
                BackwardReferenceReader.$$$reportNull$$$0(3);
            }
            if (dirtyScope == null) {
                BackwardReferenceReader.$$$reportNull$$$0(4);
            }
            if (fileType == null) {
                BackwardReferenceReader.$$$reportNull$$$0(5);
            }
            if (searchType == null) {
                BackwardReferenceReader.$$$reportNull$$$0(6);
            }
            GlobalSearchScope effectiveSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)dirtyScope).intersectWith(searchScope);
            LanguageCompilerRefAdapter adapter = LanguageCompilerRefAdapter.findAdapter(fileType);
            LOG.assertTrue(adapter != null, (Object)("adapter is null for file type: " + fileType));
            Class<? extends CompilerRef> requiredCompilerRefClass = searchType.getRequiredClass(adapter);
            HashMap candidatesPerFile = new HashMap();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)searchElement).forEach((fileId, defs) -> {
                if (searchType == null) {
                    BackwardReferenceReader.$$$reportNull$$$0(18);
                }
                List<CompilerRef> requiredCandidates = defs.stream().filter(requiredCompilerRefClass::isInstance).collect(Collectors.toList());
                if (requiredCandidates.isEmpty()) {
                    return true;
                }
                VirtualFile file = this.findFile(fileId);
                if (file != null && effectiveSearchScope.contains(file)) {
                    candidatesPerFile.put(file, searchType.convertToIds(requiredCandidates, ((JavaCompilerBackwardReferenceIndex)this.myIndex).getByteSeqEum()));
                }
                return true;
            });
            Map<Object, Object> map = candidatesPerFile.isEmpty() ? Collections.emptyMap() : candidatesPerFile;
            if (map == null) {
                BackwardReferenceReader.$$$reportNull$$$0(7);
            }
            return map;
        }

        @Override
        @Nullable
        public Integer getAnonymousCount(@NotNull CompilerRef.CompilerClassHierarchyElementDef classDef, boolean checkDefinitions) {
            if (classDef == null) {
                BackwardReferenceReader.$$$reportNull$$$0(8);
            }
            try {
                if (checkDefinitions && this.getDefinitionCount((CompilerRef.NamedCompilerRef)classDef) != DefCount.ONE) {
                    return null;
                }
                int[] count = new int[]{0};
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)classDef).forEach((id, value) -> {
                    count[0] = count[0] + value.size();
                    return true;
                });
                return count[0];
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getOccurrenceCount(@NotNull CompilerRef element) {
            if (element == null) {
                BackwardReferenceReader.$$$reportNull$$$0(9);
            }
            try {
                int[] result = new int[]{0};
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES).getData((Object)element).forEach((id, value) -> {
                    result[0] = result[0] + value;
                    return true;
                });
                return result[0];
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        List<CompilerRef> getMembersFor(@NotNull SignatureData data) {
            ArrayList<CompilerRef> arrayList;
            if (data == null) {
                BackwardReferenceReader.$$$reportNull$$$0(10);
            }
            try {
                ArrayList<CompilerRef> result = new ArrayList<CompilerRef>();
                ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_MEMBER_SIGN).getData((Object)data).forEach((id, refs) -> {
                    result.addAll((Collection<CompilerRef>)refs);
                    return true;
                });
                arrayList = result;
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
            if (arrayList == null) {
                BackwardReferenceReader.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        @NotNull
        TIntHashSet getAllContainingFileIds(@NotNull CompilerRef ref) throws StorageException {
            if (ref == null) {
                BackwardReferenceReader.$$$reportNull$$$0(12);
            }
            TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES), Collections.singletonList(ref), null, null, null);
            if (tIntHashSet == null) {
                BackwardReferenceReader.$$$reportNull$$$0(13);
            }
            return tIntHashSet;
        }

        @NotNull
        OccurrenceCounter<CompilerRef> getTypeCastOperands(@NotNull CompilerRef.CompilerClassHierarchyElementDef castType, @Nullable TIntHashSet fileIds) throws StorageException {
            if (castType == null) {
                BackwardReferenceReader.$$$reportNull$$$0(14);
            }
            OccurrenceCounter<CompilerRef> result = new OccurrenceCounter<CompilerRef>();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_CAST).getData((Object)castType).forEach((id, values) -> {
                if (fileIds != null && !fileIds.contains(id)) {
                    return true;
                }
                for (CompilerRef ref : values) {
                    result.add(ref);
                }
                return true;
            });
            OccurrenceCounter<CompilerRef> occurrenceCounter = result;
            if (occurrenceCounter == null) {
                BackwardReferenceReader.$$$reportNull$$$0(15);
            }
            return occurrenceCounter;
        }

        private void addUsages(CompilerRef usage, TIntHashSet sink) throws StorageException {
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_USAGES).getData((Object)usage).forEach((id, value) -> {
                VirtualFile file = this.findFile(id);
                if (file != null) {
                    sink.add(((VirtualFileWithId)file).getId());
                }
                return true;
            });
        }

        private VirtualFile findFile(int id) {
            try {
                String path = ((JavaCompilerBackwardReferenceIndex)this.myIndex).getFilePathEnumerator().valueOf(id);
                assert (path != null);
                return VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @Nullable(value="return null if the class hierarchy contains ambiguous qualified names")
        public CompilerRef.CompilerClassHierarchyElementDef[] getHierarchy(CompilerRef.CompilerClassHierarchyElementDef hierarchyElement, boolean checkBaseClassAmbiguity, boolean includeAnonymous, int interruptNumber) {
            try {
                THashSet result = new THashSet();
                Queue q = new Queue(10);
                q.addLast((Object)hierarchyElement);
                while (!q.isEmpty()) {
                    CompilerRef.CompilerClassHierarchyElementDef curClass = (CompilerRef.CompilerClassHierarchyElementDef)q.pullFirst();
                    if (interruptNumber != -1 && result.size() > interruptNumber) break;
                    if (!result.add(curClass)) continue;
                    if (result.size() % 100 == 0) {
                        ProgressManager.checkCanceled();
                    }
                    if (!(curClass instanceof CompilerRef.CompilerAnonymousClassDef) && (checkBaseClassAmbiguity || curClass != hierarchyElement) && this.hasMultipleDefinitions((CompilerRef.NamedCompilerRef)curClass)) {
                        return null;
                    }
                    ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)curClass).forEach((id, children) -> {
                        for (CompilerRef child : children) {
                            if (!(child instanceof CompilerRef.CompilerClassHierarchyElementDef) || !includeAnonymous && child instanceof CompilerRef.CompilerAnonymousClassDef) continue;
                            q.addLast((Object)((CompilerRef.CompilerClassHierarchyElementDef)child));
                        }
                        return true;
                    });
                }
                return result.toArray(CompilerRef.CompilerClassHierarchyElementDef.EMPTY_ARRAY);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        CompilerRef.CompilerClassHierarchyElementDef[] getDirectInheritors(CompilerRef.CompilerClassHierarchyElementDef hierarchyElement) throws StorageException {
            THashSet result = new THashSet();
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_HIERARCHY).getData((Object)hierarchyElement).forEach((arg_0, arg_1) -> BackwardReferenceReader.lambda$getDirectInheritors$7((Set)result, arg_0, arg_1));
            CompilerRef.CompilerClassHierarchyElementDef[] compilerClassHierarchyElementDefArray = result.toArray(CompilerRef.CompilerClassHierarchyElementDef.EMPTY_ARRAY);
            if (compilerClassHierarchyElementDefArray == null) {
                BackwardReferenceReader.$$$reportNull$$$0(16);
            }
            return compilerClassHierarchyElementDefArray;
        }

        private boolean hasMultipleDefinitions(CompilerRef.NamedCompilerRef def) throws StorageException {
            DefCount count = this.getDefinitionCount(def);
            if (count == DefCount.NONE) {
                String name2 = def instanceof CompilerRef.CompilerAnonymousClassDef ? String.valueOf(def.getName()) : this.getNameEnumerator().getName(def.getName());
                LOG.error("Can't get definition files for: " + name2 + ", class: " + def.getClass());
            }
            return count == DefCount.MANY;
        }

        @NotNull
        private DefCount getDefinitionCount(CompilerRef.NamedCompilerRef def) throws StorageException {
            final DefCount[] result = new DefCount[]{DefCount.NONE};
            ((JavaCompilerBackwardReferenceIndex)this.myIndex).get(JavaCompilerIndices.BACK_CLASS_DEF).getData((Object)def).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

                public boolean perform(int id, Void value) {
                    if (result[0] == DefCount.NONE) {
                        result[0] = DefCount.ONE;
                        return true;
                    }
                    if (result[0] == DefCount.ONE) {
                        result[0] = DefCount.MANY;
                        return true;
                    }
                    return false;
                }
            });
            DefCount defCount = result[0];
            if (defCount == null) {
                BackwardReferenceReader.$$$reportNull$$$0(17);
            }
            return defCount;
        }

        private static /* synthetic */ boolean lambda$getDirectInheritors$7(Set result, int id, Collection children) {
            for (CompilerRef child : children) {
                if (!(child instanceof CompilerRef.CompilerClassHierarchyElementDef) || child instanceof CompilerRef.CompilerAnonymousClassDef) continue;
                result.add((CompilerRef.CompilerClassHierarchyElementDef)child);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirtyScope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 6: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchType";
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/backwardRefs/JavaBackwardReferenceIndexReaderFactory$BackwardReferenceReader";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDef";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaBackwardReferenceIndexReaderFactory$BackwardReferenceReader";
                    break;
                }
                case 7: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectInheritors";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMembersFor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllContainingFileIds";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeCastOperands";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefinitionCount";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findReferentFileIds";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileIdsWithImplicitToString";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectInheritors";
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAnonymousCount";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getOccurrenceCount";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getMembersFor";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllContainingFileIds";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeCastOperands";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getDirectInheritors$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static enum DefCount {
            NONE,
            ONE,
            MANY;

        }
    }
}

