/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.ExcludedFromCompileFilesUtil;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DirtyScopeHolder
extends UserDataHolderBase {
    private final CompilerReferenceServiceBase<?> myService;
    private final FileDocumentManager myFileDocManager;
    private final PsiDocumentManager myPsiDocManager;
    private final Object myLock;
    private final Set<Module> myVFSChangedModules;
    private final Set<Module> myChangedModulesDuringCompilation;
    private final List<ExcludeEntryDescription> myExcludedDescriptions;
    private boolean myCompilationPhase;
    private volatile GlobalSearchScope myExcludedFilesScope;
    private final Set<String> myCompilationAffectedModules;
    private final FileTypeRegistry myFileTypeRegistry;

    public DirtyScopeHolder(@NotNull CompilerReferenceServiceBase<?> service, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager, BiConsumer<MessageBusConnection, Set<String>> compilationAffectedModulesSubscription) {
        if (service == null) {
            DirtyScopeHolder.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myVFSChangedModules = ContainerUtil.newHashSet();
        this.myChangedModulesDuringCompilation = ContainerUtil.newHashSet();
        this.myExcludedDescriptions = new SmartList();
        this.myCompilationAffectedModules = ContainerUtil.newConcurrentSet();
        this.myFileTypeRegistry = FileTypeRegistry.getInstance();
        this.myService = service;
        this.myFileDocManager = fileDocumentManager;
        this.myPsiDocManager = psiDocumentManager;
        if (CompilerReferenceService.isEnabled()) {
            MessageBusConnection connect = service.getProject().getMessageBus().connect();
            connect.subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                    if (description == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        if (DirtyScopeHolder.this.myCompilationPhase) {
                            DirtyScopeHolder.this.myExcludedDescriptions.add(description);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/compiler/backwardRefs/DirtyScopeHolder$1", "onEntryAdded"));
                }
            });
            compilationAffectedModulesSubscription.accept(connect, this.myCompilationAffectedModules);
            connect.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beforeRootsChange(ModuleRootEvent event) {
                    Object[] modules = ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules();
                    Object object = DirtyScopeHolder.this.myLock;
                    synchronized (object) {
                        ContainerUtil.addAll((Collection)DirtyScopeHolder.this.myVFSChangedModules, (Object[])modules);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compilerActivityStarted() {
        ExcludeEntryDescription[] excludeEntryDescriptions = CompilerConfiguration.getInstance((Project)this.myService.getProject()).getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = true;
            Collections.addAll(this.myExcludedDescriptions, excludeEntryDescriptions);
            this.myExcludedFilesScope = null;
            this.myCompilationAffectedModules.clear();
        }
    }

    public void upToDateChecked(boolean isUpToDate) {
        Module[] modules = (Module[])ReadAction.compute(() -> {
            Project project2 = this.myService.getProject();
            if (project2.isDisposed()) {
                return null;
            }
            return ModuleManager.getInstance((Project)project2).getModules();
        });
        if (modules == null) {
            return;
        }
        this.compilationFinished(() -> {
            if (!isUpToDate) {
                ContainerUtil.addAll(this.myVFSChangedModules, (Object[])modules);
            }
        });
    }

    void compilerActivityFinished() {
        List compiledModules = (List)ReadAction.compute(() -> {
            Project project2 = this.myService.getProject();
            if (project2.isDisposed()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myService.getProject());
            return this.myCompilationAffectedModules.stream().map(arg_0 -> ((ModuleManager)moduleManager).findModuleByName(arg_0)).collect(Collectors.toList());
        });
        this.compilationFinished(() -> {
            if (compiledModules == null) {
                return;
            }
            this.myVFSChangedModules.removeAll(compiledModules);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compilationFinished(Runnable action) {
        ExcludeEntryDescription[] descriptions;
        Object object = this.myLock;
        synchronized (object) {
            this.myCompilationPhase = false;
            action.run();
            this.myVFSChangedModules.addAll(this.myChangedModulesDuringCompilation);
            this.myChangedModulesDuringCompilation.clear();
            descriptions = this.myExcludedDescriptions.toArray(new ExcludeEntryDescription[0]);
            this.myExcludedDescriptions.clear();
        }
        this.myCompilationAffectedModules.clear();
        this.myExcludedFilesScope = ExcludedFromCompileFilesUtil.getExcludedFilesScope(descriptions, this.myService.getFileTypes(), this.myService.getProject(), this.myService.getFileIndex());
    }

    public GlobalSearchScope getDirtyScope() {
        Project project2 = this.myService.getProject();
        return (GlobalSearchScope)ReadAction.compute(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myCompilationPhase) {
                    return GlobalSearchScope.allScope((Project)project2);
                }
                if (project2.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (GlobalSearchScope)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.calculateDirtyScope(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, VirtualFileManager.getInstance(), this.myService}));
            }
        });
    }

    private GlobalSearchScope calculateDirtyScope() {
        Set<Module> dirtyModules = this.getAllDirtyModules();
        if (dirtyModules.isEmpty()) {
            return this.myExcludedFilesScope;
        }
        GlobalSearchScope dirtyModuleScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])dirtyModules.stream().map(Module::getModuleWithDependentsScope).toArray(GlobalSearchScope[]::new)));
        return dirtyModuleScope.union((SearchScope)this.myExcludedFilesScope);
    }

    @NotNull
    public Set<Module> getAllDirtyModules() {
        THashSet dirtyModules = new THashSet(this.myVFSChangedModules);
        for (Document document : this.myFileDocManager.getUnsavedDocuments()) {
            Module m;
            VirtualFile file = this.myFileDocManager.getFile(document);
            if (file == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        for (Document document : this.myPsiDocManager.getUncommittedDocuments()) {
            Module m;
            VirtualFile file;
            PsiFile psiFile = this.myPsiDocManager.getPsiFile(document);
            if (psiFile == null || (file = psiFile.getVirtualFile()) == null || (m = this.getModuleForSourceContentFile(file)) == null) continue;
            dirtyModules.add(m);
        }
        THashSet tHashSet = dirtyModules;
        if (tHashSet == null) {
            DirtyScopeHolder.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    public boolean contains(VirtualFile file) {
        return this.getDirtyScope().contains(file);
    }

    public void installVFSListener() {
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.fileChanged(event.getFile());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.fileChanged(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.fileChanged(event.getFile());
            }

            public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                if ("name".equals(event.getPropertyName()) && event.getFile().isDirectory() && event.getFile().isInLocalFileSystem()) {
                    String path = event.getFile().getPath();
                    for (Module module2 : ModuleManager.getInstance((Project)DirtyScopeHolder.this.myService.getProject()).getModules()) {
                        if (!FileUtil.isAncestor((String)path, (String)module2.getModuleFilePath(), (boolean)true)) continue;
                        this.addToDirtyModules(module2);
                    }
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(4);
                }
                if ("name".equals(event.getPropertyName()) || "symlink".equals(event.getPropertyName())) {
                    this.fileChanged(event.getFile());
                }
            }

            public void beforeContentsChange(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(5);
                }
                this.fileChanged(event.getFile());
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(6);
                }
                this.fileChanged(event.getFile());
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(7);
                }
                this.fileChanged(event.getFile());
            }

            private void fileChanged(VirtualFile file) {
                Module module2 = DirtyScopeHolder.this.getModuleForSourceContentFile(file);
                if (module2 != null) {
                    this.addToDirtyModules(module2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addToDirtyModules(Module module2) {
                Object object = DirtyScopeHolder.this.myLock;
                synchronized (object) {
                    if (DirtyScopeHolder.this.myCompilationPhase) {
                        DirtyScopeHolder.this.myChangedModulesDuringCompilation.add(module2);
                    } else {
                        DirtyScopeHolder.this.myVFSChangedModules.add(module2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCopied";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePropertyChange";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeContentsChange";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileDeletion";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileMovement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myService.getProject());
    }

    private Module getModuleForSourceContentFile(@NotNull VirtualFile file) {
        if (file == null) {
            DirtyScopeHolder.$$$reportNull$$$0(2);
        }
        FileType fileType = this.myFileTypeRegistry.getFileTypeByFileName(file.getNameSequence());
        if (this.myService.getFileTypes().contains(fileType) && this.myService.getFileIndex().isInSourceContent(file)) {
            return this.myService.getFileIndex().getModuleForFile(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<Module> getAllDirtyModulesForTest() {
        Object object = this.myLock;
        // MONITORENTER : object
        Set<Module> set = this.getAllDirtyModules();
        // MONITOREXIT : object
        if (set != null) return set;
        DirtyScopeHolder.$$$reportNull$$$0(3);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    DirtyScopeTestInfo getState() {
        Object object = this.myLock;
        // MONITORENTER : object
        Object[] vfsChangedModules = this.myVFSChangedModules.toArray(Module.EMPTY_ARRAY);
        ArrayList<Module> unsavedChangedModuleList = new ArrayList<Module>(this.getAllDirtyModules());
        ContainerUtil.removeAll(unsavedChangedModuleList, (Object[])vfsChangedModules);
        Module[] unsavedChangedModules = unsavedChangedModuleList.toArray(Module.EMPTY_ARRAY);
        ArrayList excludedFiles = this.myExcludedFilesScope instanceof Iterable ? ContainerUtil.newArrayList((Iterable)((Iterable)this.myExcludedFilesScope)) : Collections.emptyList();
        DirtyScopeTestInfo dirtyScopeTestInfo = new DirtyScopeTestInfo((Module[])vfsChangedModules, unsavedChangedModules, excludedFiles.toArray(VirtualFile.EMPTY_ARRAY), this.getDirtyScope());
        // MONITOREXIT : object
        if (dirtyScopeTestInfo != null) return dirtyScopeTestInfo;
        DirtyScopeHolder.$$$reportNull$$$0(4);
        return dirtyScopeTestInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/DirtyScopeHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirtyModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDirtyModulesForTest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForSourceContentFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

