/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.util.JdomKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000eH\u0000\u001a2\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0011\u001a\u00020\fH\u0000\u00a8\u0006\u0012"}, d2={"getFilteredModuleNameList", "", "", "project", "Lcom/intellij/openapi/project/Project;", "map", "", "isExternal", "", "readByteTargetLevel", "", "parentNode", "Lorg/jdom/Element;", "result", "", "writeBytecodeTarget", "moduleNames", "element", "intellij.java.compiler.impl"})
public final class ExternalCompilerConfigurationStorageKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getFilteredModuleNameList(@NotNull Project project2, @NotNull Map<String, String> map, boolean isExternal) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        if (map.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)project2)) {
            return CollectionsKt.toList((Iterable)map.keySet());
        }
        ModuleManagerImpl moduleManager = ModuleManagerImpl.getInstanceImpl((Project)project2);
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        Iterable iterable = $receiver$iv = (Iterable)map.keySet();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            String it = (String)element$iv$iv;
            if (moduleManager.findModuleByName(it) == null) {
                bl = !isExternal;
            } else {
                Module module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"moduleManager.findModule\u2026return@filter !isExternal");
                bl = externalProjectSystemRegistry.getExternalSource(module2) != null == isExternal;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final void writeBytecodeTarget(@NotNull List<String> moduleNames, @NotNull Map<String, String> map, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull(moduleNames, (String)"moduleNames");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Collections.sort(moduleNames, StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        for (String name2 : moduleNames) {
            Element moduleElement = JdomKt.element((Element)element, (String)"module");
            moduleElement.setAttribute("name", name2);
            String string = map.get(name2);
            if (string == null) {
                string = "";
            }
            moduleElement.setAttribute("target", string);
        }
    }

    public static final void readByteTargetLevel(@NotNull Element parentNode, @NotNull Map<String, String> result) {
        Intrinsics.checkParameterIsNotNull((Object)parentNode, (String)"parentNode");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Element element = parentNode.getChild("bytecodeTargetLevel");
        if (element == null) {
            return;
        }
        Element bytecodeTargetElement = element;
        for (Element element2 : bytecodeTargetElement.getChildren("module")) {
            String target;
            String name2;
            if (element2.getAttributeValue("name") == null) {
                continue;
            }
            if (element2.getAttributeValue("target") == null) {
                continue;
            }
            result.put(name2, target);
        }
    }
}

