/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.TripleFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompilerMessageImpl
implements CompilerMessage {
    private final Project myProject;
    private final CompilerMessageCategory myCategory;
    @Nullable
    private Navigatable myNavigatable;
    private final String myMessage;
    private final VirtualFile myFile;
    private final int myRow;
    private final int myColumn;
    @NotNull
    private TripleFunction<CompilerMessage, Integer, Integer, Integer> myColumnAdjuster;

    public CompilerMessageImpl(Project project2, CompilerMessageCategory category, String message) {
        this(project2, category, message, null, -1, -1, null);
    }

    public CompilerMessageImpl(Project project2, @NotNull CompilerMessageCategory category, String message, @Nullable VirtualFile file, int row, int column, @Nullable Navigatable navigatable) {
        if (category == null) {
            CompilerMessageImpl.$$$reportNull$$$0(0);
        }
        this.myColumnAdjuster = (msg, line, col) -> col;
        this.myProject = project2;
        this.myCategory = category;
        this.myNavigatable = navigatable;
        this.myMessage = message == null ? "" : message;
        this.myRow = row;
        this.myColumn = column;
        this.myFile = file;
    }

    public void setColumnAdjuster(@NotNull TripleFunction<CompilerMessage, Integer, Integer, Integer> columnAdjuster) {
        if (columnAdjuster == null) {
            CompilerMessageImpl.$$$reportNull$$$0(1);
        }
        this.myColumnAdjuster = columnAdjuster;
    }

    @NotNull
    public CompilerMessageCategory getCategory() {
        CompilerMessageCategory compilerMessageCategory = this.myCategory;
        if (compilerMessageCategory == null) {
            CompilerMessageImpl.$$$reportNull$$$0(2);
        }
        return compilerMessageCategory;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Navigatable getNavigatable() {
        int line;
        if (this.myNavigatable != null) {
            return this.myNavigatable;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null && virtualFile.isValid() && !virtualFile.getFileType().isBinary() && (line = this.getLine() - 1) >= 0) {
            this.myNavigatable = new OpenFileDescriptor(this.myProject, virtualFile, line, ((Integer)this.myColumnAdjuster.fun((Object)this, (Object)line, (Object)Math.max(0, this.getColumn() - 1))).intValue());
            return this.myNavigatable;
        }
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public String getExportTextPrefix() {
        if (this.getLine() >= 0) {
            return CompilerBundle.message((String)"compiler.results.export.text.prefix", (Object[])new Object[]{this.getLine()});
        }
        return "";
    }

    public String getRenderTextPrefix() {
        if (this.getLine() >= 0) {
            return "(" + this.getLine() + ", " + this.getColumn() + ")";
        }
        return "";
    }

    public int getLine() {
        return this.myRow;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompilerMessage)) {
            return false;
        }
        CompilerMessageImpl compilerMessage = (CompilerMessageImpl)o;
        if (this.myColumn != compilerMessage.myColumn) {
            return false;
        }
        if (this.myRow != compilerMessage.myRow) {
            return false;
        }
        if (!this.myCategory.equals((Object)compilerMessage.myCategory)) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(compilerMessage.myFile) : compilerMessage.myFile != null) {
            return false;
        }
        return this.myMessage.equals(compilerMessage.myMessage);
    }

    public int hashCode() {
        int result = this.myCategory.hashCode();
        result = 29 * result + this.myMessage.hashCode();
        result = 29 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 29 * result + this.myRow;
        result = 29 * result + this.myColumn;
        return result;
    }

    public String toString() {
        return this.myMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAdjuster";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerMessageImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerMessageImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setColumnAdjuster";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

