/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectSdkSetupValidator
implements ProjectSdkSetupValidator {
    public static final JavaProjectSdkSetupValidator INSTANCE = new JavaProjectSdkSetupValidator();

    public boolean isApplicableFor(@NotNull Project project2, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(1);
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE && (psiFile = PsiManager.getInstance((Project)project2).findFile(file)) != null) {
            return psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
        }
        return false;
    }

    @Nullable
    public String getErrorMessage(@NotNull Project project2, @NotNull VirtualFile file) {
        Sdk sdk;
        Module module2;
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(3);
        }
        if ((module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project2)) != null && !module2.isDisposed() && (sdk = ModuleRootManager.getInstance((Module)module2).getSdk()) == null) {
            if (ModuleRootManager.getInstance((Module)module2).isSdkInherited()) {
                return ProjectBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]);
            }
            return ProjectBundle.message((String)"module.sdk.not.defined", (Object[])new Object[0]);
        }
        return null;
    }

    public void doFix(@NotNull Project project2, @NotNull VirtualFile file) {
        Module module2;
        Sdk projectSdk;
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(5);
        }
        if ((projectSdk = ProjectSettingsService.getInstance((Project)project2).chooseAndSetSdk()) != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project2)) != null) {
            WriteAction.run(() -> ModuleRootModificationUtil.setSdkInherited((Module)module2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaProjectSdkSetupValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

