/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.api;

import com.intellij.rt.coverage.data.SingleTrFileDiscoveryProtocolDataListener;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TestDiscoveryProtocolUtil {
    public static void readFile(File file, TestDiscoveryProtocolReader reader) throws IOException {
        int bufferSize = Integer.parseInt(System.getProperty("org.jetbrains.instrumentation.trace.file.buffer.size", "32768"));
        TestDiscoveryProtocolUtil.readSequentially(new BufferedInputStream(new FileInputStream(file), bufferSize), reader);
    }

    public static void readSequentially(InputStream testDiscoveryDataStream, TestDiscoveryProtocolReader reader) throws IOException {
        DataInputStream input = new DataInputStream(testDiscoveryDataStream);
        boolean start = true;
        while (true) {
            int read;
            if ((read = input.read()) == -1) {
                reader.debug("stream ended before finish marker received");
                input.close();
                return;
            }
            byte msgType = (byte)read;
            switch (msgType) {
                case 1: {
                    byte version = input.readByte();
                    reader.testDiscoveryDataProcessingStarted(version);
                    reader.debug("start marker, format version: " + version);
                    break;
                }
                case 0: {
                    reader.testDiscoveryDataProcessingFinished();
                    reader.debug("finish marker");
                    input.close();
                    return;
                }
                case 3: {
                    reader.debug("test data received");
                    TestDiscoveryProtocolUtil.readTestData(input, reader);
                    break;
                }
                case 2: {
                    reader.debug("partial dictionary received");
                    TestDiscoveryProtocolUtil.readDictionary(input, reader);
                    break;
                }
                case 5: {
                    reader.debug("metadata received");
                    TestDiscoveryProtocolUtil.readMetadata(input, reader);
                    break;
                }
                case 6: {
                    reader.debug("class metadata received");
                    TestDiscoveryProtocolUtil.readClassMetadata(input, reader);
                    break;
                }
                case 73: {
                    byte[] jtc = new byte[3];
                    if (!start) {
                        throw new IllegalStateException("File header is not expected here");
                    }
                    if (input.read(jtc) != 3) {
                        throw new IOException("Failed to read header fully");
                    }
                    if (!Arrays.equals(jtc, SingleTrFileDiscoveryProtocolDataListener.HEADER_TAIL)) {
                        reader.error("File header mismatch: I" + new String(jtc, "ASCII"));
                    }
                    reader.debug("file header");
                    break;
                }
                default: {
                    reader.error(String.format("Unknown input: %2X", msgType));
                }
            }
            start = false;
        }
    }

    private static void readMetadata(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        TestDiscoveryProtocolReader.MetadataReader metadataReader = reader.createMetadataReader();
        int count = CoverageIOUtil.readINT(input);
        if (count == 0) {
            return;
        }
        while (count-- > 0) {
            String key = CoverageIOUtil.readUTFFast(input);
            String value = CoverageIOUtil.readUTFFast(input);
            metadataReader.processMetadataEntry(key, value);
        }
    }

    private static void readClassMetadata(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        TestDiscoveryProtocolReader.ClassMetadataReader metadataReader = reader.createClassMetadataReader();
        int classesCount = CoverageIOUtil.readINT(input);
        if (classesCount == 0) {
            return;
        }
        while (classesCount-- > 0) {
            int classId = CoverageIOUtil.readINT(input);
            if (metadataReader != null) {
                metadataReader.classStarted(classId);
            }
            int filesCount = CoverageIOUtil.readINT(input);
            while (filesCount-- > 0) {
                int fileId = CoverageIOUtil.readINT(input);
                if (metadataReader == null) continue;
                metadataReader.file(fileId);
            }
            int methodsCount = CoverageIOUtil.readINT(input);
            while (methodsCount-- > 0) {
                int methodId = CoverageIOUtil.readINT(input);
                int hashLength = CoverageIOUtil.readINT(input);
                byte[] hash = new byte[hashLength];
                int read = input.read(hash);
                assert (read == hashLength);
                if (metadataReader == null) continue;
                metadataReader.method(methodId, hash);
            }
            if (metadataReader == null) continue;
            metadataReader.classFinished(classId);
        }
        if (metadataReader != null) {
            metadataReader.finished();
        }
    }

    private static void readDictionary(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        TestDiscoveryProtocolReader.NameEnumeratorReader nameEnumeratorReader = reader.createNameEnumeratorReader();
        int count = CoverageIOUtil.readINT(input);
        while (count-- > 0) {
            int id = CoverageIOUtil.readINT(input);
            String name = CoverageIOUtil.readUTFFast(input);
            nameEnumeratorReader.enumerate(name, id);
        }
    }

    private static void readTestData(DataInputStream input, TestDiscoveryProtocolReader reader) throws IOException {
        int testClassName = CoverageIOUtil.readINT(input);
        int testMethodName = CoverageIOUtil.readINT(input);
        TestDiscoveryProtocolReader.TestDataReader testDataReader = reader.createTestDataReader(testClassName, testMethodName);
        int classCount = CoverageIOUtil.readINT(input);
        while (classCount-- > 0) {
            int classId = CoverageIOUtil.readINT(input);
            int methodCount = CoverageIOUtil.readINT(input);
            testDataReader.classProcessingStarted(classId);
            while (methodCount-- > 0) {
                int methodId = CoverageIOUtil.readINT(input);
                testDataReader.processUsedMethod(methodId);
            }
            testDataReader.classProcessingFinished(classId);
        }
        testDataReader.testDataProcessed();
    }
}

