/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryDataListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryProjectData {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/TestDiscoveryProjectData";
    public static final String TEST_DISCOVERY_DATA_LISTENER_PROP = "test.discovery.data.listener";
    protected static final TestDiscoveryProjectData ourProjectData = new TestDiscoveryProjectData();
    private final NameEnumerator myNameEnumerator;
    private final ConcurrentMap<Integer, boolean[]> myClassToVisitedMethods = new ConcurrentHashMap<Integer, boolean[]>();
    private final ConcurrentMap<Integer, int[]> myClassToMethodNames = new ConcurrentHashMap<Integer, int[]>();
    final ConcurrentMap<Integer, ClassMetadata> classesToMetadata = new ConcurrentHashMap<Integer, ClassMetadata>();
    private final TestDiscoveryDataListener myDataListener;
    private volatile boolean myFinished;

    private TestDiscoveryProjectData() {
        try {
            String testDiscoveryDataListener = System.getProperty(TEST_DISCOVERY_DATA_LISTENER_PROP);
            if (testDiscoveryDataListener == null) {
                throw new RuntimeException("Property \"test.discovery.data.listener\" should be specified");
            }
            this.myDataListener = (TestDiscoveryDataListener)Class.forName(testDiscoveryDataListener).newInstance();
            this.myNameEnumerator = this.myDataListener.getNameEnumerator();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    TestDiscoveryProjectData.this.testDiscoveryFinished();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
    }

    public static TestDiscoveryProjectData getProjectData() {
        return ourProjectData;
    }

    public static boolean[] trace(String className, boolean[] methodFlags, String[] methodNames) {
        return ourProjectData.traceLines(className, methodFlags, methodNames);
    }

    private synchronized boolean[] traceLines(String className, boolean[] methodFlags, String[] methodNames) {
        int classId = this.myNameEnumerator.enumerate(className);
        boolean[] previousMethodFlags = this.myClassToVisitedMethods.putIfAbsent(classId, methodFlags);
        if (previousMethodFlags != null) {
            if (previousMethodFlags.length == methodFlags.length) {
                return previousMethodFlags;
            }
            this.myClassToVisitedMethods.put(classId, methodFlags);
        }
        this.myClassToMethodNames.put(classId, NameEnumerator.enumerate(methodNames, this.myNameEnumerator));
        return methodFlags;
    }

    public synchronized void testDiscoveryEnded(String className, String methodName) {
        try {
            this.myDataListener.testFinished(className, methodName, this.myClassToVisitedMethods, this.myClassToMethodNames);
            block2: for (Map.Entry e : this.myClassToVisitedMethods.entrySet()) {
                for (boolean isUsed : (boolean[])e.getValue()) {
                    if (!isUsed) continue;
                    ClassMetadata cm = (ClassMetadata)this.classesToMetadata.remove(e.getKey());
                    if (cm == null) continue block2;
                    this.myDataListener.addClassMetadata(Collections.singletonList(cm));
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void testDiscoveryStarted(String className, String methodName) {
        for (Map.Entry e : this.myClassToVisitedMethods.entrySet()) {
            boolean[] used = (boolean[])e.getValue();
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i]) continue;
                used[i] = false;
            }
        }
    }

    private synchronized void testDiscoveryFinished() {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        try {
            this.myDataListener.testsFinished();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addClassMetadata(List<ClassMetadata> classMetadata) {
        for (ClassMetadata cm : classMetadata) {
            this.classesToMetadata.put(this.myNameEnumerator.enumerate(cm.getFqn()), cm);
        }
    }

    NameEnumerator getMyNameEnumerator() {
        return this.myNameEnumerator;
    }

    ConcurrentMap<Integer, int[]> getClassToMethodNames() {
        return this.myClassToMethodNames;
    }

    ConcurrentMap<Integer, boolean[]> getClassToVisitedMethods() {
        return this.myClassToVisitedMethods;
    }
}

