/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryProtocolDataListener;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleTrFileDiscoveryProtocolDataListener
extends TestDiscoveryProtocolDataListener {
    public static final String TRACE_FILE = "org.jetbrains.instrumentation.trace.file";
    public static final String BUFFER_SIZE = "org.jetbrains.instrumentation.trace.file.buffer.size";
    public static final String FILE_VERSION = "org.jetbrains.instrumentation.trace.file.version";
    public static final byte HEADER_START = 73;
    public static final byte[] HEADER_TAIL = new byte[]{74, 84, 67};
    private static final int DEFAULT_VERSION = 2;
    private final DataOutputStream myStream;
    private final NameEnumerator.Incremental myNameEnumerator;

    public SingleTrFileDiscoveryProtocolDataListener() throws Exception {
        super(Byte.parseByte(System.getProperty(FILE_VERSION, String.valueOf(2))));
        File myTraceFile = SingleTrFileDiscoveryProtocolDataListener.getCanonicalFile(new File(System.getProperty(TRACE_FILE, "td.ijtc")));
        int bufferSize = Integer.parseInt(System.getProperty(BUFFER_SIZE, "32768"));
        myTraceFile.getParentFile().mkdirs();
        this.myStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(myTraceFile), bufferSize));
        this.myNameEnumerator = new NameEnumerator.Incremental();
        this.start(this.myStream);
    }

    SingleTrFileDiscoveryProtocolDataListener(DataOutputStream stream, int version) throws Exception {
        super((byte)version);
        this.myStream = stream;
        this.myNameEnumerator = new NameEnumerator.Incremental();
        this.start(this.myStream);
    }

    @Override
    public synchronized void testFinished(String className, String methodName, Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames) throws IOException {
        this.writeTestFinished(this.myStream, className, methodName, classToVisitedMethods, classToMethodNames);
    }

    @Override
    public synchronized void testsFinished() throws IOException {
        try {
            this.writeDictionaryIncrementIfNeeded(this.myStream);
            this.finish(this.myStream);
        }
        finally {
            this.myStream.close();
        }
    }

    @Override
    public NameEnumerator.Incremental getNameEnumerator() {
        return this.myNameEnumerator;
    }

    @Override
    public synchronized void addMetadata(Map<String, String> metadata) throws IOException {
        this.writeMetadata(this.myStream, metadata);
    }

    @Override
    public void addClassMetadata(List<ClassMetadata> metadata) throws IOException {
        this.writeClassMetadata(this.myStream, metadata);
    }

    @Override
    protected synchronized void start(DataOutput output) throws IOException {
        output.writeByte(73);
        output.write(HEADER_TAIL);
        super.start(output);
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }
}

