/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import javax.swing.Icon;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.plugins.xsltDebugger.impl.XsltDebuggerEditorsProvider;
import org.jetbrains.annotations.NotNull;

public class XsltBreakpointType
extends XLineBreakpointType<XBreakpointProperties> {
    private final XsltDebuggerEditorsProvider myMyEditorsProvider1 = new XsltDebuggerEditorsProvider(XsltChecker.LanguageLevel.V1);
    private final XsltDebuggerEditorsProvider myMyEditorsProvider2 = new XsltDebuggerEditorsProvider(XsltChecker.LanguageLevel.V2);

    public XsltBreakpointType() {
        super("xslt", "XSLT Breakpoints");
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document document;
        if (file == null) {
            XsltBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            XsltBreakpointType.$$$reportNull$$$0(1);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file)) == null) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FileType fileType = psiFile.getFileType();
        return fileType == StdFileTypes.XML && XsltSupport.isXsltFile((PsiFile)psiFile);
    }

    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, @NotNull Project project) {
        XSourcePosition position;
        if (breakpoint == null) {
            XsltBreakpointType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            XsltBreakpointType.$$$reportNull$$$0(3);
        }
        if ((position = breakpoint.getSourcePosition()) == null) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(position.getFile());
        if (file == null) {
            return null;
        }
        XsltChecker.LanguageLevel level = XsltSupport.getXsltLanguageLevel((PsiFile)file);
        if (level == XsltChecker.LanguageLevel.V1) {
            return this.myMyEditorsProvider1;
        }
        if (level == XsltChecker.LanguageLevel.V2) {
            return this.myMyEditorsProvider2;
        }
        return null;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = XsltSupport.createXsltIcon((Icon)AllIcons.Debugger.Db_set_breakpoint);
        if (icon == null) {
            XsltBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = XsltSupport.createXsltIcon((Icon)AllIcons.Debugger.Db_disabled_breakpoint);
        if (icon == null) {
            XsltBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    public XBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            XsltBreakpointType.$$$reportNull$$$0(6);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xsltDebugger/XsltBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xsltDebugger/XsltBreakpointType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

