/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import org.intellij.plugins.xsltDebugger.DebuggerConnector;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.rt.engine.DebuggerStoppedException;
import org.jetbrains.annotations.NotNull;

class DebugProcessListener
extends ProcessAdapter {
    private final Project myProject;
    private final int myPort;

    public DebugProcessListener(Project project, int port) {
        this.myProject = project;
        this.myPort = port;
    }

    public void startNotified(@NotNull ProcessEvent event) {
        if (event == null) {
            DebugProcessListener.$$$reportNull$$$0(0);
        }
        DebuggerConnector connector = new DebuggerConnector(this.myProject, event.getProcessHandler(), this.myPort);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)connector);
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        if (event == null) {
            DebugProcessListener.$$$reportNull$$$0(1);
        }
        try {
            XsltDebuggerSession session = XsltDebuggerSession.getInstance(event.getProcessHandler());
            if (session != null) {
                session.stop();
            }
        }
        catch (VMPausedException vMPausedException) {
        }
        catch (DebuggerStoppedException debuggerStoppedException) {
            // empty catch block
        }
        super.processWillTerminate(event, willBeDestroyed);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            DebugProcessListener.$$$reportNull$$$0(2);
        }
        super.processTerminated(event);
        XsltDebuggerSession session = XsltDebuggerSession.getInstance(event.getProcessHandler());
        if (session != null) {
            session.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "org/intellij/plugins/xsltDebugger/DebugProcessListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startNotified";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processWillTerminate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

