/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleViewContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{GradleSourceSetData.KEY};

    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleViewContributor.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list = Arrays.asList(KEYS);
        if (list == null) {
            GradleViewContributor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result = new SmartList();
        GradleViewContributor.addCustomSourceSetsNodes(externalProjectsView, dataNodes, result);
        SmartList smartList = result;
        if (smartList == null) {
            GradleViewContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Nullable
    public String getDisplayName(@NotNull DataNode node) {
        if (node == null) {
            GradleViewContributor.$$$reportNull$$$0(3);
        }
        if (ProjectKeys.MODULE.equals((Object)node.getKey())) {
            return ((ModuleData)node.getData()).getId();
        }
        return super.getDisplayName(node);
    }

    private static void addCustomSourceSetsNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<ExternalSystemNode<?>> result) {
        Collection sourceSetsDataNodes;
        if (externalProjectsView == null) {
            GradleViewContributor.$$$reportNull$$$0(4);
        }
        if (dataNodes == null) {
            GradleViewContributor.$$$reportNull$$$0(5);
        }
        if (result == null) {
            GradleViewContributor.$$$reportNull$$$0(6);
        }
        if (!(sourceSetsDataNodes = dataNodes.get(GradleSourceSetData.KEY)).isEmpty()) {
            SourceSetsNode sourceSetsNode = new SourceSetsNode(externalProjectsView);
            for (DataNode dataNode : sourceSetsDataNodes) {
                sourceSetsNode.add(new SourceSetNode(externalProjectsView, (DataNode<GradleSourceSetData>)dataNode));
            }
            result.add(sourceSetsNode);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCustomSourceSetsNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SourceSetNode
    extends ExternalSystemNode<GradleSourceSetData> {
        public SourceSetNode(ExternalProjectsView externalProjectsView, DataNode<GradleSourceSetData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Modules.SourceFolder);
            GradleSourceSetData data = (GradleSourceSetData)((Object)this.getData());
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null);
            }
        }

        public String getName() {
            GradleSourceSetData data = (GradleSourceSetData)((Object)this.getData());
            return data != null ? StringUtil.substringAfter((String)data.getExternalName(), (String)":") : "";
        }
    }

    @Order(value=9)
    private static class SourceSetsNode
    extends ExternalSystemNode {
        public SourceSetsNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.ModuleGroup);
        }

        public String getName() {
            return "Source Sets";
        }
    }
}

