/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.execution.OutputWrapper;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (modelType == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        ModelBuilder result = connection.model(modelType);
        if (settings != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, connection);
        }
        ModelBuilder modelBuilder = result;
        if (modelBuilder == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        return modelBuilder;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        BuildLauncher result = connection.newBuild();
        if (settings != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, connection);
        }
        BuildLauncher buildLauncher = result;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        return buildLauncher;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(ProjectResolverContext projectResolverContext) {
        return GradleExecutionHelper.getBuildEnvironment(projectResolverContext.getConnection(), projectResolverContext.getExternalSystemTaskId(), projectResolverContext.getListener());
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ProjectConnection connection) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        GradleExecutionHelper.prepare(operation, id, settings, listener, connection, new OutputWrapper(listener, id, true), new OutputWrapper(listener, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError) {
        Application application;
        String gradleVersion;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (standardOutput == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (standardError == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        Set jvmArgs = settings.getVmOptions();
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener);
        String string = gradleVersion = buildEnvironment != null ? buildEnvironment.getGradle().getGradleVersion() : null;
        if (!jvmArgs.isEmpty()) {
            Set merged = buildEnvironment != null ? GradleExecutionHelper.mergeJvmArgs(settings.getServiceDirectory(), buildEnvironment.getJava().getJvmArguments(), jvmArgs) : jvmArgs;
            List filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation.setJvmArguments(ArrayUtil.toStringArray((Collection)filteredArgs));
        }
        if (settings.isOfflineWork()) {
            settings.withArgument("--offline");
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode()) {
            if (!settings.getArguments().contains("--quiet") && !settings.getArguments().contains("--debug")) {
                settings.withArgument("--info");
            }
            settings.withArgument("--recompile-scripts");
        }
        if (!settings.getArguments().isEmpty()) {
            String loggableArgs = StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(settings.getArguments()), (String)" ");
            LOG.info("Passing command-line args to Gradle Tooling API: " + loggableArgs);
            List filteredArgs = ContainerUtil.mapNotNull((Collection)settings.getArguments(), s -> StringUtil.isEmpty((String)s) ? null : s);
            GradleExecutionHelper.replaceTestCommandOptionWithInitScript(filteredArgs);
            operation.withArguments(ArrayUtil.toStringArray((Collection)filteredArgs));
        }
        GradleExecutionHelper.setupEnvironment(operation, settings, gradleVersion, id, listener);
        String javaHome = settings.getJavaHome();
        if (javaHome != null && new File(javaHome).isDirectory()) {
            operation.setJavaHome(new File(javaHome));
        }
        String buildRootDir = buildEnvironment == null ? null : buildEnvironment.getBuildIdentifier().getRootDir().getPath();
        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
        operation.addProgressListener((ProgressListener)gradleProgressListener);
        operation.setStandardOutput(standardOutput);
        operation.setStandardError(standardError);
        InputStream inputStream = (InputStream)settings.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @Nullable String gradleVersion, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener) {
        boolean isEnvironmentCustomizationSupported;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        boolean bl = isEnvironmentCustomizationSupported = gradleVersion != null && GradleVersion.version((String)gradleVersion).getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0;
        if (!isEnvironmentCustomizationSupported) {
            if (!settings.isPassParentEnvs() || !settings.getEnv().isEmpty()) {
                listener.onTaskOutput(taskId, String.format("The version of Gradle you are using%s does not support the environment variables customization feature. Support for this is available in Gradle 3.5 and all later versions.\n", gradleVersion == null ? "" : " (" + gradleVersion + ")"), false);
            }
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings.getEnv());
        commandLine.withParentEnvironmentType(settings.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull Function<ProjectConnection, T> f) {
        File projectPathFile;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        String projectDir = (projectPathFile = new File(projectPath)).isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null ? projectPathFile.getParent() : projectPath;
        String userDir = null;
        if (!GradleEnvironment.ADJUST_USER_DIR) {
            try {
                userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    System.setProperty("user.dir", projectDir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProjectConnection connection = GradleExecutionHelper.getConnection(projectDir, settings);
        try {
            Object object = f.fun((Object)connection);
            return (T)object;
        }
        catch (ExternalSystemException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.debug("Gradle execution error", e);
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            throw new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
        }
        finally {
            try {
                connection.close();
                if (userDir != null) {
                    System.setProperty("user.dir", userDir);
                }
            }
            catch (Throwable e) {
                LOG.debug("Gradle connection close error", e);
            }
        }
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (!settings.getDistributionType().isWrapped()) {
            return;
        }
        if (settings.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        long ttlInMs = settings.getRemoteProcessIdleTtlInMs();
        ProjectConnection connection = GradleExecutionHelper.getConnection(projectPath, settings);
        try {
            settings.setRemoteProcessIdleTtlInMs(100L);
            try {
                File wrapperFilesLocation = FileUtil.createTempDirectory((String)"wrap", (String)"loc");
                String fileName = "gradle-wrapper";
                File jarFile = new File(wrapperFilesLocation, "gradle-wrapper.jar");
                File scriptFile = new File(wrapperFilesLocation, "gradlew");
                File pathToProperties = new File(wrapperFilesLocation, "path.tmp");
                Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)wrapperFilesLocation)));
                String[] lines = new String[]{"", "gradle.projectsEvaluated { gr ->", "  def wrapper = gr.rootProject.tasks[\"wrapper\"]", "  if (wrapper != null) {", "    if (wrapper.jarFile.exists()) {", "      wrapper.jarFile = new File('" + StringUtil.escapeBackSlashes((String)jarFile.getCanonicalPath()) + "')", "      wrapper.scriptFile = new File('" + StringUtil.escapeBackSlashes((String)scriptFile.getCanonicalPath()) + "')", "    }", "    wrapper.doLast {", "      new File('" + StringUtil.escapeBackSlashes((String)pathToProperties.getCanonicalPath()) + "').write wrapper.propertiesFile.getCanonicalPath()", "    }", "  }", "}", ""};
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator()));
                settings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
                BuildLauncher launcher = this.getBuildLauncher(id, connection, settings, listener);
                launcher.withCancellationToken(cancellationToken);
                launcher.forTasks(new String[]{"wrapper"});
                launcher.run();
                settings.setWrapperPropertyFile(FileUtil.loadFile((File)pathToProperties));
            }
            catch (IOException e) {
                LOG.warn("Can't update wrapper", (Throwable)e);
            }
        }
        catch (Throwable e) {
            LOG.warn("Can't update wrapper", e);
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
            throw new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause));
        }
        finally {
            settings.setRemoteProcessIdleTtlInMs(ttlInMs);
            try {
                connection.close();
            }
            catch (Throwable e) {}
        }
    }

    private static List<String> mergeJvmArgs(String serviceDirectory, List<String> jvmArgs, Set<String> jvmArgsFromIdeSettings) {
        File gradleUserHomeDir = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        LOG.debug("Gradle home: " + gradleUserHomeDir);
        NativeServices.initialize((File)gradleUserHomeDir);
        LinkedHashMap<Object, String> mergedArgs = new LinkedHashMap<Object, String>();
        for (Object jvmArg : ContainerUtil.concat((Iterable[])new Iterable[]{jvmArgs, jvmArgsFromIdeSettings})) {
            int n = ((String)jvmArg).indexOf(61);
            if (n <= 0) {
                mergedArgs.put(jvmArg, "");
                continue;
            }
            mergedArgs.put(((String)jvmArg).substring(0, n), ((String)jvmArg).substring(n));
        }
        ArrayList<String> mergedList = new ArrayList<String>();
        for (Map.Entry entry : mergedArgs.entrySet()) {
            mergedList.add((String)entry.getKey() + (String)entry.getValue());
        }
        JvmOptions jvmOptions = new JvmOptions(null);
        jvmOptions.setAllJvmArgs(mergedList);
        return jvmOptions.getAllJvmArgs();
    }

    @NotNull
    private static ProjectConnection getConnection(@NotNull String projectPath, @Nullable GradleExecutionSettings settings) throws IllegalStateException {
        Application app;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        File projectDir = new File(projectPath);
        GradleConnector connector = GradleConnector.newConnector();
        int ttl = -1;
        if (settings != null) {
            File serviceDirectory = settings.getServiceDirectory() == null ? null : new File(settings.getServiceDirectory());
            File gradleHome = settings.getGradleHome() == null ? null : new File(settings.getGradleHome());
            switch (settings.getDistributionType()) {
                case LOCAL: {
                    if (gradleHome == null) break;
                    connector.useInstallation(gradleHome);
                    break;
                }
                case WRAPPED: {
                    if (settings.getWrapperPropertyFile() == null) break;
                    DistributionFactoryExt.setWrappedDistribution(connector, settings.getWrapperPropertyFile(), serviceDirectory);
                }
            }
            if (serviceDirectory != null) {
                connector.useGradleUserHomeDir(serviceDirectory);
            }
            if (settings.isVerboseProcessing() && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).setVerboseLogging(true);
            }
            ttl = (int)settings.getRemoteProcessIdleTtlInMs();
        }
        int n = ttl = (app = ApplicationManager.getApplication()) != null && app.isUnitTestMode() ? 10000 : ttl;
        if (ttl > 0 && connector instanceof DefaultGradleConnector) {
            ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
        }
        connector.forProjectDirectory(projectDir);
        ProjectConnection connection = connector.connect();
        if (connection == null) {
            throw new IllegalStateException(String.format("Can't create connection to the target project via gradle tooling api. Project path: '%s'", projectPath));
        }
        ProjectConnection projectConnection = connection;
        if (projectConnection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        return projectConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File generateInitScript(boolean isBuildSrcProject, @NotNull Set<Class> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/init.gradle");
        try {
            if (stream == null) {
                LOG.warn("Can't get init script template");
                File file = null;
                return file;
            }
            String toolingExtensionsJarPaths = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${EXTENSIONS_JARS_PATH}"), toolingExtensionsJarPaths);
            if (isBuildSrcProject) {
                String buildSrcDefaultInitScript = GradleExecutionHelper.getBuildSrcDefaultInitScript();
                if (buildSrcDefaultInitScript == null) {
                    File file = null;
                    return file;
                }
                script = script + buildSrcDefaultInitScript;
            }
            File file = GradleExecutionHelper.writeToFileGradleInitScript(script);
            return file;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static File writeToFileGradleInitScript(@NotNull String content) throws IOException {
        if (content == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        return GradleExecutionHelper.writeToFileGradleInitScript(content, "ijinit");
    }

    public static File writeToFileGradleInitScript(@NotNull String content, @NotNull String filePrefix) throws IOException {
        File tempFile;
        if (content == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        if (filePrefix == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        if ((tempFile = new File(FileUtil.getTempDirectory(), filePrefix + '.' + "gradle")).exists() && StringUtil.equals((CharSequence)content, (CharSequence)FileUtil.loadFile((File)tempFile))) {
            return tempFile;
        }
        tempFile = FileUtil.findSequentNonexistentFile((File)tempFile.getParentFile(), (String)filePrefix, (String)"gradle");
        FileUtil.writeToFile((File)tempFile, (String)content);
        tempFile.deleteOnExit();
        return tempFile;
    }

    @Nullable
    public static String getBuildSrcDefaultInitScript() {
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/buildSrcInit.gradle");
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            String string = FileUtil.loadTextAndClose((InputStream)stream);
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't use IJ gradle init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener);
        GradleVersion gradleVersion = null;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener, taskId);
        modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
        modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
        modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener, taskId, true));
        modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener, taskId, false));
        BuildEnvironment buildEnvironment = (BuildEnvironment)modelBuilder.get();
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Gradle version: " + buildEnvironment.getGradle().getGradleVersion());
                LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }
        return buildEnvironment;
    }

    private static void replaceTestCommandOptionWithInitScript(@NotNull List<String> args) {
        if (args == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        LinkedHashSet testIncludePatterns = ContainerUtil.newLinkedHashSet();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!"--tests".equals(next)) continue;
            it.remove();
            if (!it.hasNext()) continue;
            testIncludePatterns.add(it.next());
            it.remove();
        }
        if (!testIncludePatterns.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            Iterator iterator = testIncludePatterns.iterator();
            while (iterator.hasNext()) {
                String pattern = (String)iterator.next();
                buf.append('\'').append(pattern).append('\'');
                if (!iterator.hasNext()) continue;
                buf.append(',');
            }
            buf.append(']');
            String path = GradleExecutionHelper.renderInitScript(buf.toString());
            if (path != null) {
                ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", path});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String renderInitScript(@NotNull String testArgs) {
        if (testArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/testFilterInit.gradle");
        try {
            if (stream == null) {
                LOG.error("Can't get test filter init script template");
                String string = null;
                return string;
            }
            String script = FileUtil.loadTextAndClose((InputStream)stream).replaceFirst(Pattern.quote("${TEST_NAME_INCLUDES}"), Matcher.quoteReplacement(testArgs));
            File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijtestinit");
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle test filter init script", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    @NotNull
    private static String getToolingExtensionsJarPaths(@NotNull Set<Class> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        Set jarPaths = ContainerUtil.map2SetNotNull(toolingExtensionClasses, aClass -> {
            String path = PathManager.getJarPathForClass((Class)aClass);
            if (path != null) {
                if (FileUtil.getNameWithoutExtension((String)path).equals("gradle-api-" + GradleVersion.current().getBaseVersion())) {
                    LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
                    return null;
                }
                return PathUtil.getCanonicalPath((String)path);
            }
            return null;
        });
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = jarPaths.iterator();
        while (it.hasNext()) {
            String jarPath = (String)it.next();
            buf.append('\"').append(jarPath).append('\"');
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        String string = buf.toString();
        if (string == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs) {
        if (modelType == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        if (extraJvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        ModelBuilder result = connection.model(modelType);
        GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, extraJvmArgs, ContainerUtil.newArrayList(), connection);
        ModelBuilder modelBuilder = result;
        if (modelBuilder == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        return modelBuilder;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> vmOptions, @NotNull List<String> commandLineArgs) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(53);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(54);
        }
        if (vmOptions == null) {
            GradleExecutionHelper.$$$reportNull$$$0(55);
        }
        if (commandLineArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(56);
        }
        BuildLauncher result = connection.newBuild();
        GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings, listener, vmOptions, commandLineArgs, connection);
        BuildLauncher buildLauncher = result;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(57);
        }
        return buildLauncher;
    }

    @NotNull
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(58);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs, @NotNull ProjectConnection connection) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(60);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(61);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(62);
        }
        if (extraJvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(63);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(64);
        }
        if (settings == null) {
            return;
        }
        settings.withVmOptions(extraJvmArgs);
        GradleExecutionHelper.prepare(operation, id, settings, listener, connection, new OutputWrapper(listener, id, true), new OutputWrapper(listener, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs, @NotNull List<String> commandLineArgs, @NotNull ProjectConnection connection) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(65);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(66);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(67);
        }
        if (extraJvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(68);
        }
        if (commandLineArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(69);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(70);
        }
        if (settings == null) {
            return;
        }
        settings.withArguments(commandLineArgs).withVmOptions(extraJvmArgs);
        GradleExecutionHelper.prepare(operation, id, settings, listener, connection, new OutputWrapper(listener, id, true), new OutputWrapper(listener, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull List<String> extraJvmArgs, @NotNull List<String> commandLineArgs, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(71);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(72);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(73);
        }
        if (listener == null) {
            GradleExecutionHelper.$$$reportNull$$$0(74);
        }
        if (extraJvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(75);
        }
        if (commandLineArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(76);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(77);
        }
        if (standardOutput == null) {
            GradleExecutionHelper.$$$reportNull$$$0(78);
        }
        if (standardError == null) {
            GradleExecutionHelper.$$$reportNull$$$0(79);
        }
        settings.withArguments(commandLineArgs).withVmOptions(extraJvmArgs);
        GradleExecutionHelper.prepare(operation, id, settings, listener, connection, standardOutput, standardError);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 31: 
            case 45: 
            case 51: 
            case 57: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 31: 
            case 45: 
            case 51: 
            case 57: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelType";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 15: 
            case 25: 
            case 47: 
            case 52: 
            case 61: 
            case 66: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 18: 
            case 36: 
            case 39: 
            case 48: 
            case 53: 
            case 64: 
            case 70: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 17: 
            case 28: 
            case 38: 
            case 41: 
            case 49: 
            case 54: 
            case 62: 
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: 
            case 31: 
            case 45: 
            case 51: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 9: 
            case 14: 
            case 21: 
            case 60: 
            case 65: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 11: 
            case 16: 
            case 22: 
            case 27: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 19: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardOutput";
                break;
            }
            case 20: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardError";
                break;
            }
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 32: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArgs";
                break;
            }
            case 50: 
            case 63: 
            case 68: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraJvmArgs";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 56: 
            case 69: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArgs";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 4: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 8: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsJarPaths";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilder";
                break;
            }
            case 4: 
            case 8: 
            case 31: 
            case 45: 
            case 51: 
            case 57: 
            case 59: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureInstalledWrapper";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getConnection";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateInitScript";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "writeToFileGradleInitScript";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "replaceTestCommandOptionWithInitScript";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "renderInitScript";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getToolingExtensionsJarPaths";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 31: 
            case 45: 
            case 51: 
            case 57: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

