/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public class BuildScriptDataBuilder {
    @NotNull
    private final VirtualFile myBuildScriptFile;
    protected final Set<String> imports;
    protected final Set<String> plugins;
    protected final Set<String> pluginsInGroup;
    protected final Set<String> repositories;
    protected final Set<String> dependencies;
    protected final Set<String> properties;
    protected final Set<String> buildScriptProperties;
    protected final Set<String> buildScriptRepositories;
    protected final Set<String> buildScriptDependencies;
    protected final Set<String> other;
    protected final GradleVersion myGradleVersion;

    public BuildScriptDataBuilder(@NotNull VirtualFile buildScriptFile) {
        if (buildScriptFile == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(0);
        }
        this(buildScriptFile, GradleVersion.current());
    }

    public BuildScriptDataBuilder(@NotNull VirtualFile buildScriptFile, @NotNull GradleVersion gradleVersion) {
        if (buildScriptFile == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(1);
        }
        if (gradleVersion == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(2);
        }
        this.imports = ContainerUtil.newTreeSet();
        this.plugins = ContainerUtil.newTreeSet();
        this.pluginsInGroup = ContainerUtil.newTreeSet();
        this.repositories = ContainerUtil.newTreeSet();
        this.dependencies = ContainerUtil.newTreeSet();
        this.properties = ContainerUtil.newTreeSet();
        this.buildScriptProperties = ContainerUtil.newTreeSet();
        this.buildScriptRepositories = ContainerUtil.newTreeSet();
        this.buildScriptDependencies = ContainerUtil.newTreeSet();
        this.other = ContainerUtil.newTreeSet();
        this.myBuildScriptFile = buildScriptFile;
        this.myGradleVersion = gradleVersion;
    }

    @NotNull
    public VirtualFile getBuildScriptFile() {
        VirtualFile virtualFile = this.myBuildScriptFile;
        if (virtualFile == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public GradleVersion getGradleVersion() {
        GradleVersion gradleVersion = this.myGradleVersion;
        if (gradleVersion == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(4);
        }
        return gradleVersion;
    }

    public String build() {
        return this.buildMainPart();
    }

    public String buildImports() {
        if (!this.imports.isEmpty()) {
            return StringUtil.join(this.imports, (String)"\n") + "\n";
        }
        return "";
    }

    public String buildConfigurationPart() {
        ArrayList lines = ContainerUtil.newArrayList();
        this.addBuildscriptLines(lines, (Function<String, String>)((Function)BuildScriptDataBuilder::padding));
        if (!this.pluginsInGroup.isEmpty()) {
            lines.add("plugins {");
            lines.addAll(ContainerUtil.map(this.pluginsInGroup, BuildScriptDataBuilder::padding));
            lines.add("}");
            lines.add("");
        }
        return StringUtil.join((Collection)lines, (String)"\n");
    }

    public String buildMainPart() {
        ArrayList lines = ContainerUtil.newArrayList();
        this.addPluginsLines(lines, (Function<String, String>)((Function)BuildScriptDataBuilder::padding));
        if (!this.properties.isEmpty()) {
            lines.addAll(this.properties);
            lines.add("");
        }
        if (!this.repositories.isEmpty()) {
            lines.add("repositories {");
            lines.addAll(ContainerUtil.map(this.repositories, BuildScriptDataBuilder::padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.dependencies.isEmpty()) {
            lines.add("dependencies {");
            lines.addAll(ContainerUtil.map(this.dependencies, BuildScriptDataBuilder::padding));
            lines.add("}");
            lines.add("");
        }
        if (!this.other.isEmpty()) {
            lines.addAll(this.other);
        }
        return StringUtil.join((Collection)lines, (String)"\n");
    }

    protected void addPluginsLines(@NotNull List<String> lines, @NotNull Function<String, String> padding) {
        if (lines == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(5);
        }
        if (padding == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(6);
        }
        if (!this.plugins.isEmpty()) {
            lines.addAll(this.plugins);
            lines.add("");
        }
    }

    private void addBuildscriptLines(@NotNull List<String> lines, @NotNull Function<String, String> padding) {
        if (lines == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(7);
        }
        if (padding == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(8);
        }
        if (!(this.buildScriptRepositories.isEmpty() && this.buildScriptDependencies.isEmpty() && this.buildScriptProperties.isEmpty())) {
            lines.add("buildscript {");
            List buildScriptLines = ContainerUtil.newSmartList();
            if (!this.buildScriptProperties.isEmpty()) {
                buildScriptLines.addAll(this.buildScriptProperties);
                buildScriptLines.add("");
            }
            if (!this.buildScriptRepositories.isEmpty()) {
                buildScriptLines.add("repositories {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptRepositories, padding));
                buildScriptLines.add("}");
            }
            if (!this.buildScriptDependencies.isEmpty()) {
                buildScriptLines.add("dependencies {");
                buildScriptLines.addAll(ContainerUtil.map(this.buildScriptDependencies, padding));
                buildScriptLines.add("}");
            }
            lines.addAll(ContainerUtil.map((Collection)buildScriptLines, padding));
            lines.add("}");
            lines.add("");
        }
    }

    public BuildScriptDataBuilder addImport(@NotNull String importString) {
        if (importString == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(9);
        }
        this.imports.add(importString);
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptPropertyDefinition(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(10);
        }
        this.buildScriptProperties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptRepositoriesDefinition(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(11);
        }
        this.buildScriptRepositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addBuildscriptDependencyNotation(@NotNull String notation) {
        if (notation == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(12);
        }
        this.buildScriptDependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPluginDefinitionInPluginsGroup(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(13);
        }
        this.pluginsInGroup.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addPluginDefinition(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(14);
        }
        this.plugins.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addRepositoriesDefinition(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(15);
        }
        this.repositories.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addDependencyNotation(@NotNull String notation) {
        if (notation == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(16);
        }
        this.dependencies.add(notation.trim());
        return this;
    }

    public BuildScriptDataBuilder addPropertyDefinition(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(17);
        }
        this.properties.add(definition.trim());
        return this;
    }

    public BuildScriptDataBuilder addOther(@NotNull String definition) {
        if (definition == null) {
            BuildScriptDataBuilder.$$$reportNull$$$0(18);
        }
        this.other.add(definition.trim());
        return this;
    }

    private static String padding(String s) {
        return StringUtil.isNotEmpty((String)s) ? "    " + s : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildScriptFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "padding";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importString";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildScriptFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPluginsLines";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBuildscriptLines";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addBuildscriptPropertyDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBuildscriptRepositoriesDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBuildscriptDependencyNotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPluginDefinitionInPluginsGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPluginDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoriesDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addDependencyNotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addOther";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

