/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.template;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.Serializable;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.exception.GenerateCodeException;

public class TemplateResource
implements Serializable {
    private final boolean isDefault;
    private String fileName = "";
    private String template = "";
    private String className;

    public TemplateResource(String fileName, String template, boolean aDefault) {
        this.isDefault = aDefault;
        this.fileName = fileName;
        this.template = template;
    }

    public TemplateResource(String fileName, String template, boolean isDefault, String className) {
        this(fileName, template, isDefault);
        this.className = className;
    }

    public TemplateResource() {
        this.isDefault = false;
    }

    public static String after(String s, String token) {
        if (s == null) {
            return null;
        }
        int i = s.indexOf(token);
        if (i == -1) {
            return s;
        }
        return s.substring(i + token.length());
    }

    public static String before(String s, String token) {
        if (s == null) {
            return null;
        }
        int i = s.lastIndexOf(token);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Nullable
    public String getJavaDoc() {
        int i;
        int n = i = this.template.trim().startsWith("/*") ? this.template.indexOf("*/") : -1;
        if (i == -1) {
            return null;
        }
        return this.template.substring(0, i + 2);
    }

    public String getMethodBody() {
        return TemplateResource.getMethodBody(this.template);
    }

    @Nullable
    private static String getMethodBody(String template) {
        String signature = TemplateResource.getMethodSignature(template);
        String s = TemplateResource.after(template, signature);
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        return trimmed.substring(1, trimmed.length() - 1);
    }

    public String getMethodSignature() {
        return TemplateResource.getMethodSignature(this.template);
    }

    private static String getMethodSignature(String template) {
        String[] lines;
        String trimmed = template.trim();
        String s = trimmed.startsWith("/*") ? TemplateResource.after(trimmed, "*/") : trimmed;
        int indexOf = s.indexOf(123);
        if (indexOf > 0) {
            return s.substring(0, indexOf).trim();
        }
        StringBuffer signature = new StringBuffer();
        for (String line : lines = s.split("\n")) {
            if ((line = line.trim()).startsWith("@")) continue;
            signature.append(line);
            if (line.indexOf(123) > -1) break;
        }
        String result = signature.toString();
        return result.substring(0, result.lastIndexOf("{"));
    }

    public String getTargetMethodName(PsiClass clazz) {
        try {
            String text2 = GenerationUtil.velocityGenerateCode(clazz, Collections.emptyList(), Collections.emptyMap(), this.template, 0, true);
            return JavaPsiFacade.getElementFactory((Project)clazz.getProject()).createMethodFromText(text2, (PsiElement)clazz, PsiUtil.getLanguageLevel((PsiElement)clazz)).getName();
        }
        catch (IncorrectOperationException | GenerateCodeException ignore) {
            return null;
        }
    }

    public boolean isValidTemplate() {
        return TemplateResource.isValidTemplate(this.template);
    }

    public static boolean isValidTemplate(String template) {
        if ((template = template.trim()).indexOf(123) == -1) {
            return false;
        }
        String s = template.trim();
        if (s.lastIndexOf(125) != s.length() - 1) {
            return false;
        }
        if (TemplateResource.getMethodSignature(template) == null) {
            return false;
        }
        return TemplateResource.getMethodBody(template) != null;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return this.fileName != null ? this.fileName : this.template;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateResource)) {
            return false;
        }
        TemplateResource that = (TemplateResource)o;
        return this.fileName.equals(that.fileName) && this.template.equals(that.template);
    }

    public int hashCode() {
        return 31 * this.fileName.hashCode() + this.template.hashCode();
    }
}

