/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.config.FilterPattern;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class GenerateToStringUtils {
    private static final Logger log = Logger.getInstance((String)"#GenerateToStringUtils");

    private GenerateToStringUtils() {
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, FilterPattern pattern) {
        PsiField[] psiFieldArray = GenerateToStringUtils.filterAvailableFields(clazz, false, pattern);
        if (psiFieldArray == null) {
            GenerateToStringUtils.$$$reportNull$$$0(0);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, boolean includeSuperClass, FilterPattern pattern) {
        if (log.isDebugEnabled()) {
            log.debug("Filtering fields using the pattern: " + pattern);
        }
        ArrayList<PsiField> availableFields = new ArrayList<PsiField>();
        GenerateToStringUtils.collectAvailableFields(clazz, includeSuperClass, pattern, availableFields, new HashSet<PsiClass>());
        PsiField[] psiFieldArray = availableFields.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            GenerateToStringUtils.$$$reportNull$$$0(1);
        }
        return psiFieldArray;
    }

    private static void collectAvailableFields(PsiClass clazz, boolean includeSuperClass, FilterPattern pattern, List<PsiField> availableFields, HashSet<PsiClass> visited) {
        PsiField[] fields;
        PsiClass superClass;
        int sortElements = GenerateToStringContext.getConfig().getSortElements();
        if (includeSuperClass && sortElements == 3 && (superClass = clazz.getSuperClass()) != null && visited.add(superClass)) {
            GenerateToStringUtils.collectAvailableFields(superClass, true, pattern, availableFields, visited);
        }
        for (PsiField field : fields = includeSuperClass && sortElements != 3 ? clazz.getAllFields() : clazz.getFields()) {
            if (!JavaResolveUtil.isAccessible((PsiMember)field, field.getContainingClass(), field.getModifierList(), (PsiElement)clazz, null, null) || pattern.fieldMatches(field)) continue;
            availableFields.add(field);
        }
    }

    @NotNull
    public static PsiMethod[] filterAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern) {
        if (pattern == null) {
            GenerateToStringUtils.$$$reportNull$$$0(2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Filtering methods using the pattern: " + pattern);
        }
        ArrayList<PsiMethod> availableMethods = new ArrayList<PsiMethod>();
        GenerateToStringUtils.collectAvailableMethods(clazz, pattern, availableMethods, new HashSet<PsiClass>());
        PsiMethod[] psiMethodArray = availableMethods.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            GenerateToStringUtils.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    private static void collectAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern, List<PsiMethod> availableMethods, HashSet<PsiClass> visited) {
        PsiMethod[] methods;
        PsiClass superClass;
        int sortElements;
        if (pattern == null) {
            GenerateToStringUtils.$$$reportNull$$$0(4);
        }
        if ((sortElements = GenerateToStringContext.getConfig().getSortElements()) == 3 && (superClass = clazz.getSuperClass()) != null && visited.add(superClass)) {
            GenerateToStringUtils.collectAvailableMethods(superClass, pattern, availableMethods, visited);
        }
        for (PsiMethod method : methods = sortElements != 3 ? clazz.getAllMethods() : clazz.getMethods()) {
            String methodName;
            String fieldName;
            PsiType returnType;
            if (!PsiAdapter.isGetterMethod(method) || (returnType = method.getReturnType()) == null || PsiType.VOID.equals((Object)returnType) || !method.hasModifierProperty("public") || method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || clazz.findFieldByName(fieldName = PsiAdapter.getGetterFieldName(method), false) != null || "toString".equals(methodName = method.getName()) || "getClass".equals(methodName) || "hashCode".equals(methodName) || pattern.methodMatches(method)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding the method " + methodName + " as there is not a field for this getter");
            }
            availableMethods.add(method);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/generate/GenerateToStringUtils";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableFields";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/generate/GenerateToStringUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterAvailableMethods";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAvailableMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

