/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeIfOrPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeIfOrIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeIfOrPredicate mergeIfOrPredicate = new MergeIfOrPredicate();
        if (mergeIfOrPredicate == null) {
            MergeIfOrIntention.$$$reportNull$$$0(0);
        }
        return mergeIfOrPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token;
        if (element == null) {
            MergeIfOrIntention.$$$reportNull$$$0(1);
        }
        if (MergeIfOrPredicate.isMergableExplicitIf((PsiElement)(token = (PsiJavaToken)element))) {
            MergeIfOrIntention.replaceMergeableExplicitIf(token);
        } else {
            MergeIfOrIntention.replaceMergeableImplicitIf(token);
        }
    }

    private static void replaceMergeableExplicitIf(PsiJavaToken token) {
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        assert (parentStatement != null);
        PsiIfStatement childStatement = (PsiIfStatement)parentStatement.getElseBranch();
        if (childStatement == null) {
            return;
        }
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String childConditionText = tracker.text(childCondition, 14);
        PsiExpression condition2 = parentStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String parentConditionText = tracker.text(condition2, 14);
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        if (parentThenBranch == null) {
            return;
        }
        String parentThenBranchText = tracker.text((PsiElement)parentThenBranch);
        StringBuilder statement = new StringBuilder();
        statement.append("if(");
        statement.append(parentConditionText);
        statement.append("||");
        statement.append(childConditionText);
        statement.append(')');
        statement.append(parentThenBranchText);
        PsiStatement childElseBranch = childStatement.getElseBranch();
        if (childElseBranch != null) {
            statement.append("\nelse ");
            statement.append(tracker.text((PsiElement)childElseBranch));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, statement.toString(), tracker);
    }

    private static void replaceMergeableImplicitIf(PsiJavaToken token) {
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        PsiIfStatement childStatement = (PsiIfStatement)PsiTreeUtil.skipWhitespacesForward((PsiElement)parentStatement);
        assert (childStatement != null);
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        CommentTracker parentTracker = new CommentTracker();
        CommentTracker childTracker = new CommentTracker();
        String childConditionText = childTracker.text(childCondition, 14);
        PsiExpression condition2 = parentStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String parentConditionText = parentTracker.text(condition2, 14);
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        if (parentThenBranch == null) {
            return;
        }
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        newStatement.append(parentConditionText);
        newStatement.append("||");
        newStatement.append(childConditionText);
        newStatement.append(')');
        newStatement.append(parentTracker.text((PsiElement)parentThenBranch));
        PsiStatement childElseBranch = childStatement.getElseBranch();
        if (childElseBranch != null) {
            newStatement.append("\nelse ");
            newStatement.append(childTracker.text((PsiElement)childElseBranch));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, newStatement.toString(), parentTracker);
        childTracker.deleteAndRestoreComments((PsiElement)childStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/trivialif/MergeIfOrIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/trivialif/MergeIfOrIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

