/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailExceptionsPredicate
implements PsiElementPredicate {
    DetailExceptionsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiTryStatement tryStatement = (PsiTryStatement)ObjectUtils.chooseNotNull((Object)DetailExceptionsPredicate.getTryStatementIfKeyword(element), (Object)DetailExceptionsPredicate.getTryStatementIfParameter(element));
        if (tryStatement == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        Set<PsiClassType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryStatement.getResourceList(), exceptionsThrown);
        Set<PsiType> exceptionsCaught = ExceptionUtils.getExceptionTypesHandled(tryStatement);
        for (PsiType psiType : exceptionsThrown) {
            if (exceptionsCaught.contains(psiType)) continue;
            for (PsiType typeCaught : exceptionsCaught) {
                if (!typeCaught.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiTryStatement getTryStatementIfParameter(@NotNull PsiElement element) {
        PsiParameter parameter2;
        if (element == null) {
            DetailExceptionsPredicate.$$$reportNull$$$0(0);
        }
        if ((parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class)) == null) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiCatchSection.class);
        if (catchSection == null) {
            return null;
        }
        return (PsiTryStatement)ObjectUtils.tryCast((Object)catchSection.getParent(), PsiTryStatement.class);
    }

    @Nullable
    private static PsiTryStatement getTryStatementIfKeyword(@NotNull PsiElement element) {
        if (element == null) {
            DetailExceptionsPredicate.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        IElementType tokenType = ((PsiJavaToken)element).getTokenType();
        if (!JavaTokenType.TRY_KEYWORD.equals(tokenType) && !JavaTokenType.CATCH_KEYWORD.equals(tokenType)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCatchSection) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiTryStatement)) {
            return null;
        }
        return (PsiTryStatement)parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/siyeh/ipp/exceptions/DetailExceptionsPredicate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTryStatementIfParameter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTryStatementIfKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

