/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyConcatenatedStringToClipboardIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate(false);
        if (simpleStringConcatenationPredicate == null) {
            CopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(0);
        }
        return simpleStringConcatenationPredicate;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            CopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiPolyadicExpression)) {
            return;
        }
        PsiPolyadicExpression concatenationExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = concatenationExpression.getOperationTokenType();
        if (tokenType != JavaTokenType.PLUS) {
            return;
        }
        PsiType type2 = concatenationExpression.getType();
        if (type2 == null || !type2.equalsToText("java.lang.String")) {
            return;
        }
        String text2 = CopyConcatenatedStringToClipboardIntention.buildConcatenationText(concatenationExpression);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
    }

    public static String buildConcatenationText(PsiPolyadicExpression polyadicExpression) {
        StringBuilder out = new StringBuilder();
        for (PsiElement element : polyadicExpression.getChildren()) {
            if (element instanceof PsiExpression) {
                PsiExpression expression2 = (PsiExpression)element;
                Object value2 = ExpressionUtils.computeConstantExpression(expression2);
                if (value2 == null) {
                    out.append('?');
                    continue;
                }
                out.append(value2.toString());
                continue;
            }
            if (!(element instanceof PsiWhiteSpace) || !element.getText().contains("\n") || out.length() != 0 && out.charAt(out.length() - 1) == '\n') continue;
            out.append('\n');
        }
        return out.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/concatenation/CopyConcatenatedStringToClipboardIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/concatenation/CopyConcatenatedStringToClipboardIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

