/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessarySemicolonInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.semicolon.display.name", new Object[0]);
        if (string == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.semicolon.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySemicolonVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarySemicolonFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !LanguageUtil.isInTemplateLanguageFile((PsiElement)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessarySemicolonInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessarySemicolonVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySemicolonVisitor() {
        }

        public void visitFile(PsiFile file) {
            this.findTopLevelSemicolons((PsiElement)file);
            super.visitFile(file);
        }

        public void visitImportList(PsiImportList list) {
            this.findTopLevelSemicolons((PsiElement)list);
            super.visitImportList(list);
        }

        public void visitModule(PsiJavaModule module) {
            this.findTopLevelSemicolons((PsiElement)module);
            super.visitModule(module);
        }

        private void findTopLevelSemicolons(PsiElement element) {
            PsiElement sibling = element.getFirstChild();
            while (sibling != null) {
                if (sibling instanceof PsiErrorElement) {
                    return;
                }
                if (PsiUtil.isJavaToken((PsiElement)sibling, (IElementType)JavaTokenType.SEMICOLON)) {
                    this.registerError(sibling, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                }
                sibling = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(sibling);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement element;
            if (aClass == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            this.findUnnecessarySemicolonsAfterEnumConstants(aClass);
            if (!aClass.isEnum()) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length > 0) {
                PsiField lastField = fields[fields.length - 1];
                if (!(lastField instanceof PsiEnumConstant)) {
                    return;
                }
                element = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments((PsiElement)lastField);
            } else {
                PsiElement lBrace = aClass.getLBrace();
                element = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(lBrace);
            }
            if (!(element instanceof PsiJavaToken)) {
                return;
            }
            PsiJavaToken token = (PsiJavaToken)element;
            IElementType tokenType = token.getTokenType();
            if (!tokenType.equals(JavaTokenType.SEMICOLON)) {
                return;
            }
            PsiElement next = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(element);
            if (next == null || !next.equals(aClass.getRBrace())) {
                return;
            }
            this.registerError(element, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private void findUnnecessarySemicolonsAfterEnumConstants(@NotNull PsiClass aClass) {
            if (aClass == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(1);
            }
            PsiElement child = aClass.getFirstChild();
            while (child != null) {
                PsiElement prevSibling;
                PsiJavaToken token;
                IElementType tokenType;
                if (child instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)child).getTokenType()).equals(JavaTokenType.SEMICOLON) && !((prevSibling = UnnecessarySemicolonVisitor.skipBackwardWhiteSpacesAndComments(child)) instanceof PsiEnumConstant)) {
                    if (prevSibling instanceof PsiJavaToken) {
                        IElementType prevTokenType = ((PsiJavaToken)prevSibling).getTokenType();
                        if (!JavaTokenType.COMMA.equals(prevTokenType) && !JavaTokenType.LBRACE.equals(prevTokenType)) {
                            this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                    } else {
                        this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                    }
                }
                child = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(child);
            }
        }

        @Nullable
        private static PsiElement skipForwardWhiteSpacesAndComments(PsiElement element) {
            return PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        }

        @Nullable
        private static PsiElement skipBackwardWhiteSpacesAndComments(PsiElement element) {
            return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element);
        }

        public void visitEmptyStatement(PsiEmptyStatement statement) {
            super.visitEmptyStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement semicolon = statement.getFirstChild();
                if (semicolon == null) {
                    return;
                }
                this.registerError(semicolon, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            PsiElement prev;
            super.visitResourceList(resourceList);
            PsiElement last = resourceList.getLastChild();
            if (PsiUtil.isJavaToken((PsiElement)last, (IElementType)JavaTokenType.RPARENTH) && PsiUtil.isJavaToken((PsiElement)(prev = UnnecessarySemicolonVisitor.skipBackwardWhiteSpacesAndComments(last)), (IElementType)JavaTokenType.SEMICOLON)) {
                this.registerError(prev, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "aClass";
            objectArray2[1] = "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findUnnecessarySemicolonsAfterEnumConstants";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnnecessarySemicolonFix
    extends InspectionGadgetsFix {
        private UnnecessarySemicolonFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.semicolon.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySemicolonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement semicolonElement = descriptor.getPsiElement();
            PsiElement parent = semicolonElement.getParent();
            if (parent instanceof PsiEmptyStatement) {
                PsiElement lastChild = parent.getLastChild();
                if (lastChild instanceof PsiComment) {
                    parent.replace(lastChild);
                } else {
                    UnnecessarySemicolonFix.deleteElement(parent);
                }
            } else {
                UnnecessarySemicolonFix.deleteElement(semicolonElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonFix", "getFamilyName"));
        }
    }
}

