/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryFullyQualifiedNameInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreJavadoc;
    public boolean ignoreInModuleStatements = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean inSameFile = (Boolean)infos[0];
        if (inSameFile) {
            String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.problem.descriptor2", new Object[0]);
            if (string == null) {
                UnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.problem.descriptor1", new Object[0]);
        if (string == null) {
            UnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.in.module.statements.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInModuleStatements");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryFullyQualifiedNameFix((Boolean)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFullyQualifiedNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryFullyQualifiedNameVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFullyQualifiedNameVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            this.checkReference((PsiJavaCodeReferenceElement)expression2);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            this.checkReference(reference);
        }

        private void checkReference(PsiJavaCodeReferenceElement reference) {
            PsiJavaCodeReferenceElement qualifierReference;
            PsiElement qualifierTarget;
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (parent instanceof PsiMethodCallExpression || parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class, PsiAnnotation.class});
            if (element != null && !(element instanceof PsiAnnotation)) {
                return;
            }
            PsiFile containingFile = reference.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            CodeStyleSettings styleSettings = CodeStyle.getSettings((PsiFile)reference.getContainingFile());
            PsiDocComment containingComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiDocComment.class);
            boolean reportAsInformationInsideJavadoc = false;
            if (containingComment != null) {
                if (this.acceptFqnInJavadoc((PsiJavaFile)containingFile, styleSettings)) {
                    return;
                }
                JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)styleSettings.getCustomSettings(JavaCodeStyleSettings.class);
                if (javaSettings.CLASS_NAMES_IN_JAVADOC == 1) {
                    boolean bl = reportAsInformationInsideJavadoc = !ImportHelper.isAlreadyImported((PsiJavaFile)containingFile, reference.getQualifiedName());
                }
            }
            if (!((qualifierTarget = (qualifierReference = (PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiPackage)) {
                return;
            }
            SmartList references = new SmartList();
            references.add(reference);
            if (((JavaCodeStyleSettings)styleSettings.getCustomSettings(JavaCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS) {
                this.collectInnerClassNames(reference, (List<PsiJavaCodeReferenceElement>)references);
            }
            Collections.reverse(references);
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)containingFile.getProject()).getResolveHelper();
            for (PsiJavaCodeReferenceElement aReference : references) {
                ProblemHighlightType highlightType;
                PsiClass aClass;
                String qualifiedName;
                PsiElement referenceTarget = aReference.resolve();
                if (!(referenceTarget instanceof PsiClass) || (qualifiedName = (aClass = (PsiClass)referenceTarget).getQualifiedName()) == null || !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)containingFile, null) || !ImportUtils.nameCanBeImported(qualifiedName, (PsiElement)reference)) continue;
                PsiElement qualifier1 = aReference.getQualifier();
                if (qualifier1 == null) break;
                PsiElement elementToHighlight = qualifier1;
                if (reportAsInformationInsideJavadoc || UnnecessaryFullyQualifiedNameInspection.this.ignoreInModuleStatements && PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiUsesStatement.class, PsiProvidesStatement.class}) != null || InspectionProjectProfileManager.isInformationLevel((String)UnnecessaryFullyQualifiedNameInspection.this.getShortName(), (PsiElement)aReference) && this.isOnTheFly()) {
                    if (!this.isOnTheFly()) {
                        return;
                    }
                    highlightType = ProblemHighlightType.INFORMATION;
                    elementToHighlight = aReference;
                } else {
                    highlightType = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                }
                boolean inSameFile = aClass.getContainingFile() == containingFile || ImportHelper.isAlreadyImported((PsiJavaFile)containingFile, qualifiedName);
                this.registerError(elementToHighlight, highlightType, new Object[]{inSameFile});
                break;
            }
        }

        private void collectInnerClassNames(PsiJavaCodeReferenceElement reference, List<PsiJavaCodeReferenceElement> references) {
            PsiJavaCodeReferenceElement parentReference;
            PsiElement rParent = reference.getParent();
            while (rParent instanceof PsiJavaCodeReferenceElement && reference.equals((parentReference = (PsiJavaCodeReferenceElement)rParent).getQualifier())) {
                references.add(parentReference);
                rParent = rParent.getParent();
            }
        }

        private boolean acceptFqnInJavadoc(PsiJavaFile javaFile, CodeStyleSettings styleSettings) {
            if ("package-info.java".equals(javaFile.getName())) {
                return true;
            }
            return ((JavaCodeStyleSettings)styleSettings.getCustomSettings(JavaCodeStyleSettings.class)).useFqNamesInJavadocAlways();
        }
    }

    public static class QualificationRemover
    extends JavaRecursiveElementWalkingVisitor {
        private final String fullyQualifiedText;
        private final List<PsiElement> shortenedElements = new ArrayList<PsiElement>();

        public QualificationRemover(String fullyQualifiedText) {
            this.fullyQualifiedText = fullyQualifiedText;
        }

        @NotNull
        public Collection<PsiElement> getShortenedElements() {
            Collection<PsiElement> collection = Collections.unmodifiableCollection(this.shortenedElements);
            if (collection == null) {
                QualificationRemover.$$$reportNull$$$0(0);
            }
            return collection;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            PsiElement qualifier;
            super.visitReferenceElement(reference);
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class);
            if (parent != null) {
                return;
            }
            String text2 = reference.getText();
            if (!text2.equals(this.fullyQualifiedText)) {
                return;
            }
            PsiDocComment containingComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiDocComment.class);
            if (containingComment != null) {
                PsiFile file = reference.getContainingFile();
                if ("package-info.java".equals(file.getName())) {
                    return;
                }
                JavaCodeStyleSettings javaSettings = JavaCodeStyleSettings.getInstance(reference.getContainingFile());
                if (javaSettings.useFqNamesInJavadocAlways()) {
                    return;
                }
            }
            if ((qualifier = reference.getQualifier()) == null) {
                return;
            }
            qualifier.delete();
            this.shortenedElements.add((PsiElement)reference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection$QualificationRemover", "getShortenedElements"));
        }
    }

    private static class UnnecessaryFullyQualifiedNameFix
    extends InspectionGadgetsFix {
        private final boolean inSameFile;

        public UnnecessaryFullyQualifiedNameFix(boolean inSameFile) {
            this.inSameFile = inSameFile;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace fully qualified name" == null) {
                UnnecessaryFullyQualifiedNameFix.$$$reportNull$$$0(0);
            }
            return "Replace fully qualified name";
        }

        @NotNull
        public String getName() {
            String string = this.inSameFile ? InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.remove.quickfix", new Object[0]) : InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.replace.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryFullyQualifiedNameFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiJavaCodeReferenceElement referenceElement = descriptor.getHighlightType() == ProblemHighlightType.INFORMATION ? (PsiJavaCodeReferenceElement)element : (PsiJavaCodeReferenceElement)element.getParent();
            PsiFile file = referenceElement.getContainingFile();
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !ImportUtils.nameCanBeImported(qualifiedName, (PsiElement)referenceElement)) {
                return;
            }
            ImportUtils.addImportIfNeeded(aClass, (PsiElement)referenceElement);
            String fullyQualifiedText = referenceElement.getText();
            QualificationRemover qualificationRemover = new QualificationRemover(fullyQualifiedText);
            file.accept((PsiElementVisitor)qualificationRemover);
            if (this.isOnTheFly()) {
                Collection<PsiElement> shortenedElements = qualificationRemover.getShortenedElements();
                HighlightUtils.highlightElements(shortenedElements);
                UnnecessaryFullyQualifiedNameFix.showStatusMessage(file.getProject(), shortenedElements.size());
            }
        }

        private static void showStatusMessage(Project project, int elementCount) {
            WindowManager windowManager = WindowManager.getInstance();
            StatusBar statusBar = windowManager.getStatusBar(project);
            if (statusBar == null) {
                return;
            }
            statusBar.setInfo(InspectionGadgetsBundle.message("unnecessary.fully.qualified.name.status.bar.escape.highlighting.message", elementCount));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryFullyQualifiedNameInspection$UnnecessaryFullyQualifiedNameFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

