/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsCalledOnEnumConstantInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.display.name", new Object[0]);
        if (string == null) {
            EqualsCalledOnEnumConstantInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsCalledOnEnumConstantInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement element = (PsiElement)infos[0];
        boolean negated = (Boolean)infos[1];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return null;
        }
        return new EqualsToEqualityFix(negated);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsCalledOnEnumValueVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EqualsCalledOnEnumValueVisitor
    extends BaseInspectionVisitor {
        private EqualsCalledOnEnumValueVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                EqualsCalledOnEnumValueVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            EqualityCheck check = EqualityCheck.from((PsiExpression)expression2);
            if (check == null) {
                return;
            }
            PsiExpression left = check.getLeft();
            if (!TypeUtils.expressionHasTypeOrSubtype(left, "java.lang.Enum")) {
                return;
            }
            PsiExpression right = check.getRight();
            PsiType comparedTypeErasure = TypeConversionUtil.erasure((PsiType)left.getType());
            PsiType comparisonTypeErasure = TypeConversionUtil.erasure((PsiType)right.getType());
            if (comparedTypeErasure == null || comparisonTypeErasure == null || !TypeConversionUtil.areTypesConvertible((PsiType)comparedTypeErasure, (PsiType)comparisonTypeErasure)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            boolean negated = parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
            this.registerMethodCallError(expression2, expression2, negated);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection$EqualsCalledOnEnumValueVisitor", "visitMethodCallExpression"));
        }
    }
}

