/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CStyleArrayDeclarationInspection
extends BaseInspection {
    public boolean ignoreVariables = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("c.style.array.declaration.display.name", new Object[0]);
        if (string == null) {
            CStyleArrayDeclarationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("cstyle.array.method.declaration.problem.descriptor", new Object[0]);
            if (string == null) {
                CStyleArrayDeclarationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        int choice = info instanceof PsiField ? 1 : (info instanceof PsiParameter ? 2 : 3);
        String string = InspectionGadgetsBundle.message("cstyle.array.variable.declaration.problem.descriptor", choice);
        if (string == null) {
            CStyleArrayDeclarationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore C-style declarations in variables", (InspectionProfileEntry)this, "ignoreVariables");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CStyleArrayDeclarationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CStyleArrayDeclarationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/CStyleArrayDeclarationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CStyleArrayDeclarationVisitor
    extends BaseInspectionVisitor {
        private CStyleArrayDeclarationVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                CStyleArrayDeclarationVisitor.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable);
            if (CStyleArrayDeclarationInspection.this.ignoreVariables) {
                return;
            }
            PsiType declaredType = variable.getType();
            if (declaredType.getArrayDimensions() == 0) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType elementType = typeElement.getType();
            if (elementType.equals(declaredType)) {
                return;
            }
            this.registerVariableError(variable, variable);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (returnType == null || returnType.getArrayDimensions() == 0) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (type2.equals(returnType)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/style/CStyleArrayDeclarationInspection$CStyleArrayDeclarationVisitor", "visitVariable"));
        }
    }

    private static class CStyleArrayDeclarationFix
    extends InspectionGadgetsFix {
        private CStyleArrayDeclarationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("c.style.array.declaration.replace.quickfix", new Object[0]);
            if (string == null) {
                CStyleArrayDeclarationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                variable.normalizeDeclaration();
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)variable);
            } else if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                if (returnTypeElement == null) {
                    return;
                }
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return;
                }
                PsiParameterList child = method.getParameterList();
                while (!(child instanceof PsiCodeBlock)) {
                    PsiJavaToken token;
                    IElementType tokenType;
                    PsiParameterList element1 = child;
                    child = child.getNextSibling();
                    if (!(element1 instanceof PsiJavaToken) || !JavaTokenType.LBRACKET.equals(tokenType = (token = (PsiJavaToken)element1).getTokenType()) && !JavaTokenType.RBRACKET.equals(tokenType)) continue;
                    token.delete();
                }
                PsiTypeElement typeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElement(returnType);
                returnTypeElement.replace((PsiElement)typeElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/CStyleArrayDeclarationInspection$CStyleArrayDeclarationFix", "getFamilyName"));
        }
    }
}

