/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.style.Variance;
import com.siyeh.ig.style.VarianceCandidate;
import com.siyeh.ig.style.VarianceUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedWildcardInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(BoundedWildcardInspection.class);
    public boolean REPORT_INVARIANT_CLASSES = true;
    public boolean REPORT_PRIVATE_METHODS = true;
    private JBCheckBox myReportInvariantClassesCB;
    private JPanel myPanel;
    private JBCheckBox myReportPrivateMethodsCB;

    public BoundedWildcardInspection() {
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bounded.wildcard.display.name", new Object[0]);
        if (string == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                VarianceCandidate candidate = VarianceCandidate.findVarianceCandidate(typeElement);
                if (candidate == null) {
                    return;
                }
                PsiTypeParameterListOwner owner = candidate.typeParameter.getOwner();
                if (owner instanceof PsiClass && !BoundedWildcardInspection.this.REPORT_INVARIANT_CLASSES && VarianceUtil.getClassVariance((PsiClass)owner, candidate.typeParameter) == Variance.INVARIANT) {
                    return;
                }
                if (!BoundedWildcardInspection.this.REPORT_PRIVATE_METHODS && candidate.method.hasModifierProperty("private")) {
                    return;
                }
                Project project = holder.getProject();
                boolean canBeSuper = BoundedWildcardInspection.canChangeTo(project, candidate, false);
                boolean canBeExtends = BoundedWildcardInspection.canChangeTo(project, candidate, true);
                if (canBeExtends == canBeSuper || VarianceUtil.areBoundsSaturated(candidate, canBeExtends)) {
                    return;
                }
                boolean wildCardIsUseless = VarianceUtil.wildCardIsUseless(candidate, canBeExtends);
                ProblemHighlightType type2 = wildCardIsUseless ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String msg = (canBeExtends ? InspectionGadgetsBundle.message("bounded.wildcard.covariant.descriptor", new Object[0]) : InspectionGadgetsBundle.message("bounded.wildcard.contravariant.descriptor", new Object[0])) + (wildCardIsUseless ? " but decided against it" : "");
                if (!wildCardIsUseless || LOG.isDebugEnabled()) {
                    holder.registerProblem((PsiElement)typeElement, msg, type2, new LocalQuickFix[]{new ReplaceWithQuestionTFix(BoundedWildcardInspection.isOverriddenOrOverrides(candidate.method), canBeExtends)});
                }
            }
        };
        if (javaElementVisitor == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    @NotNull
    private static PsiClassReferenceType suggestMethodParameterType(@NotNull VarianceCandidate candidate, boolean isExtends) {
        if (candidate == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(4);
        }
        PsiType type2 = candidate.type;
        PsiManager psiManager = candidate.method.getManager();
        PsiElementFactory pf = PsiElementFactory.SERVICE.getInstance((Project)psiManager.getProject());
        PsiTypeElement newInnerTypeElement = pf.createTypeElement((PsiType)(isExtends ? PsiWildcardType.createExtends((PsiManager)psiManager, (PsiType)type2) : PsiWildcardType.createSuper((PsiManager)psiManager, (PsiType)type2)));
        PsiClassReferenceType methodParamType = candidate.methodParameterType;
        PsiClassReferenceType clone = new PsiClassReferenceType((PsiJavaCodeReferenceElement)methodParamType.getReference().copy(), methodParamType.getLanguageLevel());
        PsiAnnotation[] annotations2 = methodParamType.getApplicableAnnotations();
        PsiJavaCodeReferenceElement cloneReference = clone.getReference();
        for (int i = annotations2.length - 1; i >= 0; --i) {
            PsiAnnotation annotation = annotations2[i];
            cloneReference.addBefore((PsiElement)annotation, cloneReference.getFirstChild());
        }
        PsiTypeElement innerTypeElement = cloneReference.getParameterList().getTypeParameterElements()[candidate.typeParameterIndex];
        innerTypeElement.replace((PsiElement)newInnerTypeElement);
        PsiClassReferenceType psiClassReferenceType = clone;
        if (psiClassReferenceType == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(5);
        }
        return psiClassReferenceType;
    }

    private static boolean isOverriddenOrOverrides(@NotNull PsiMethod method) {
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(6);
        }
        if (method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    private static PsiField findFieldAssignedFromMethodParameter(@NotNull PsiParameter methodParameter, @NotNull PsiMethod method) {
        PsiCodeBlock methodBody2;
        if (methodParameter == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(7);
        }
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(8);
        }
        if ((methodBody2 = method.getBody()) == null) {
            return null;
        }
        Ref assignedToField = Ref.create();
        ReferencesSearch.search((PsiElement)methodParameter, (SearchScope)new LocalSearchScope((PsiElement)methodBody2)).forEach(ref -> {
            ProgressManager.checkCanceled();
            Pair<PsiField, PsiType> assigned = BoundedWildcardInspection.isAssignedToField(ref);
            if (assigned != null) {
                if (!assignedToField.isNull() && !assigned.equals(assignedToField.get())) {
                    assignedToField.set(null);
                    return false;
                }
                assignedToField.set(assigned);
            }
            return true;
        });
        return (PsiField)Pair.getFirst((Pair)((Pair)assignedToField.get()));
    }

    private static boolean canChangeTo(@NotNull Project project, @NotNull VarianceCandidate candidate, boolean isExtends) {
        PsiMethod method;
        PsiCodeBlock methodBody2;
        if (project == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(9);
        }
        if (candidate == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(10);
        }
        if ((methodBody2 = (method = candidate.method).getBody()) == null) {
            return false;
        }
        PsiClassReferenceType newParameterType = BoundedWildcardInspection.suggestMethodParameterType(candidate, isExtends);
        PsiMethod methodCopy = (PsiMethod)DebugUtil.performPsiModification((String)"Creating method copy", () -> {
            if (project == null) {
                BoundedWildcardInspection.$$$reportNull$$$0(32);
            }
            if (candidate == null) {
                BoundedWildcardInspection.$$$reportNull$$$0(33);
            }
            return BoundedWildcardInspection.createMethodCopy(project, candidate.method, candidate.methodParameterIndex, newParameterType);
        });
        PsiClass containingClass = candidate.method.getContainingClass();
        PsiField field = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method);
        ArrayList<PsiElement> superMethodsCalls = new ArrayList<PsiElement>();
        BoundedWildcardInspection.findSuperMethodCallsInside(methodCopy, candidate.superMethods, superMethodsCalls);
        if (field == null && containingClass.findMethodsByName(candidate.method.getName()).length == 1) {
            return BoundedWildcardInspection.errorChecks((PsiElement)methodCopy.getBody(), superMethodsCalls);
        }
        PsiClass classCopy = (PsiClass)DebugUtil.performPsiModification((String)"Creating class copy", () -> {
            if (project == null) {
                BoundedWildcardInspection.$$$reportNull$$$0(30);
            }
            if (candidate == null) {
                BoundedWildcardInspection.$$$reportNull$$$0(31);
            }
            return BoundedWildcardInspection.createClassCopy(project, field, containingClass, candidate.method, methodCopy, newParameterType);
        });
        return BoundedWildcardInspection.errorChecks((PsiElement)classCopy, superMethodsCalls);
    }

    private static void findSuperMethodCallsInside(@NotNull PsiMethod method, final @NotNull List<PsiMethod> superMethods, final @NotNull List<? super PsiElement> result) {
        PsiCodeBlock body2;
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(11);
        }
        if (superMethods == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(12);
        }
        if (result == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(13);
        }
        if ((body2 = method.getBody()) == null || superMethods.isEmpty()) {
            return;
        }
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiMethod called = expression2.resolveMethod();
                if (superMethods.contains(called)) {
                    result.add(expression2);
                }
                super.visitMethodCallExpression(expression2);
            }
        });
    }

    @NotNull
    private static PsiMethod createMethodCopy(@NotNull Project project, PsiMethod method, int methodParameterIndex, @NotNull PsiClassReferenceType newParameterExtends) {
        if (project == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(14);
        }
        if (newParameterExtends == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(15);
        }
        JavaDummyHolder dummyHolder = (JavaDummyHolder)DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project), (PsiElement)method);
        PsiMethod methodCopy = (PsiMethod)dummyHolder.add((PsiElement)method);
        if (methodParameterIndex != -1) {
            PsiTypeElement paramTE = methodCopy.getParameterList().getParameters()[methodParameterIndex].getTypeElement();
            ReplaceWithQuestionTFix.replaceType(project, paramTE, (PsiType)newParameterExtends);
        }
        dummyHolder.setInjectedDeclarations((processor, state, lastParent, place) -> processor.execute((PsiElement)methodCopy, state));
        PsiMethod psiMethod = methodCopy;
        if (psiMethod == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(16);
        }
        return psiMethod;
    }

    @NotNull
    private static PsiClass createClassCopy(@NotNull Project project, @Nullable PsiField field, @NotNull PsiClass containingClass, @NotNull PsiMethod method, @NotNull PsiMethod methodCopy, @NotNull PsiClassReferenceType newParameterExtends) {
        if (project == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(17);
        }
        if (containingClass == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(18);
        }
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(19);
        }
        if (methodCopy == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(20);
        }
        if (newParameterExtends == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(21);
        }
        JavaDummyHolder dummyHolder = (JavaDummyHolder)DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project), (PsiElement)containingClass);
        PsiClass classCopy = (PsiClass)dummyHolder.add((PsiElement)containingClass);
        if (field != null) {
            PsiField fieldCopy = classCopy.findFieldByName(field.getName(), false);
            ReplaceWithQuestionTFix.replaceType(project, fieldCopy.getTypeElement(), (PsiType)newParameterExtends);
        }
        int methodIndex = ArrayUtil.indexOf((Object[])containingClass.getMethods(), (Object)method);
        PsiMethod methodInClassCopy = classCopy.getMethods()[methodIndex];
        methodInClassCopy.replace((PsiElement)methodCopy);
        PsiClass psiClass = classCopy;
        if (psiClass == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(22);
        }
        return psiClass;
    }

    private static boolean errorChecks(@NotNull PsiElement method, final @NotNull List<PsiElement> elementsToIgnore) {
        if (method == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(23);
        }
        if (elementsToIgnore == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(24);
        }
        final HighlightVisitor visitor = ((HighlightVisitor)ContainerUtil.find((Object[])Extensions.getExtensions((ExtensionPointName)HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)method.getProject()), h -> h instanceof HighlightVisitorImpl)).clone();
        final HighlightInfoHolder holder = new HighlightInfoHolder(method.getContainingFile(), new HighlightInfoFilter[0]);
        visitor.analyze(method.getContainingFile(), false, holder, () -> {
            if (method == null) {
                BoundedWildcardInspection.$$$reportNull$$$0(28);
            }
            if (elementsToIgnore == null) {
                BoundedWildcardInspection.$$$reportNull$$$0(29);
            }
            method.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (elementsToIgnore.contains(element)) {
                        return;
                    }
                    visitor.visit(element);
                    if (holder.hasErrorResults()) {
                        this.stopWalking();
                    }
                    super.visitElement(element);
                }
            });
        });
        return !holder.hasErrorResults();
    }

    private static PsiElement skipParensAndCastsUp(@NotNull PsiElement element) {
        if (element == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(25);
        }
        PsiElement prev = element;
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression && ((PsiTypeCastExpression)parent).getOperand() == prev) {
            prev = parent;
            parent = parent.getParent();
        }
        return parent;
    }

    private static PsiExpression skipParensAndCastsDown(@Nullable PsiExpression element) {
        while (element instanceof PsiParenthesizedExpression || element instanceof PsiTypeCastExpression) {
            if (element instanceof PsiParenthesizedExpression) {
                element = ((PsiParenthesizedExpression)element).getExpression();
            }
            if (!(element instanceof PsiTypeCastExpression)) continue;
            element = ((PsiTypeCastExpression)element).getOperand();
        }
        return element;
    }

    private static Pair<PsiField, PsiType> isAssignedToField(@NotNull PsiReference ref) {
        PsiElement refElement;
        PsiElement parent;
        if (ref == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(26);
        }
        if (!((parent = BoundedWildcardInspection.skipParensAndCastsUp(refElement = ref.getElement())) instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ) {
            return null;
        }
        PsiExpression r = ((PsiAssignmentExpression)parent).getRExpression();
        if (!PsiTreeUtil.isAncestor((PsiElement)r, (PsiElement)refElement, (boolean)false)) {
            return null;
        }
        PsiExpression l = BoundedWildcardInspection.skipParensAndCastsDown(((PsiAssignmentExpression)parent).getLExpression());
        if (!(l instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression lExpression = (PsiReferenceExpression)l;
        PsiExpression lQualifier = BoundedWildcardInspection.skipParensAndCastsDown(lExpression.getQualifierExpression());
        if (lQualifier != null && !(lQualifier instanceof PsiThisExpression)) {
            return null;
        }
        PsiElement field = lExpression.resolve();
        if (!(field instanceof PsiField) || !((PsiField)field).hasModifierProperty("private") && !((PsiField)field).hasModifierProperty("packageLocal")) {
            return null;
        }
        PsiType type2 = r.getType();
        if (type2 == null) {
            return null;
        }
        return Pair.createNonNull((Object)((PsiField)field), (Object)type2);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        this.myReportInvariantClassesCB.setSelected(this.REPORT_INVARIANT_CLASSES);
        this.myReportPrivateMethodsCB.setSelected(this.REPORT_PRIVATE_METHODS);
        return this.myPanel;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            BoundedWildcardInspection.$$$reportNull$$$0(27);
        }
        super.readSettings(node);
        this.myReportInvariantClassesCB.addItemListener(__ -> {
            this.REPORT_INVARIANT_CLASSES = this.myReportInvariantClassesCB.isSelected();
        });
        this.myReportPrivateMethodsCB.addItemListener(__ -> {
            this.REPORT_PRIVATE_METHODS = this.myReportPrivateMethodsCB.isSelected();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/BoundedWildcardInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 10: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParameter";
                break;
            }
            case 9: 
            case 14: 
            case 17: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethods";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterExtends";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCopy";
                break;
            }
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToIgnore";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/BoundedWildcardInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestMethodParameterType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodCopy";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassCopy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestMethodParameterType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOverriddenOrOverrides";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFieldAssignedFromMethodParameter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canChangeTo";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodCallsInside";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCopy";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createClassCopy";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "errorChecks";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "skipParensAndCastsUp";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAssignedToField";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$errorChecks$5";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canChangeTo$2";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canChangeTo$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myReportInvariantClassesCB = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Report invariant classes");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        ((Component)jEditorPane).setEnabled(true);
        jEditorPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n    <b>Invariant</b> classes (e.g. <code>java.util.List&lt;T&gt;</code>) are \n    classes that both accept values (via its <code>List.add(T)</code> method) \n    and produce values (via its <code>T List.get()</code> method). On the \n    other hand, <b>contravariant</b> classes only receive values, e.g. <code>java.util.function.Consumer&lt;T&gt;</code> \n    with the only method <code>accept(T)</code>, and <b>covariant</b> classes \n    only produce values, e.g. <code>java.util.function.Supplier&lt;T&gt;</code> \n    with the only method <code>T get()</code>. People and Nikolay in \n    particular are often OK with bounded wildcards in covariant/contravariant \n    classes but afraid of wildcards in invariant classes, e.g. <code>void \n    process(List&lt;? extends T&gt; l)</code>. Turn this setting off to ignore \n    these invariant classes and leave them rigidly typed, e.g. <code>void \n    process(List&lt;T&gt; l)</code>.\n  </body>\n</html>\n");
        jPanel.add((Component)jEditorPane, new GridConstraints(2, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.myReportPrivateMethodsCB = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Report private methods");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ReplaceWithQuestionTFix
    implements LocalQuickFix {
        private final boolean isOverriddenOrOverrides;
        private final boolean isExtends;

        ReplaceWithQuestionTFix(boolean isOverriddenOrOverrides, boolean isExtends) {
            this.isOverriddenOrOverrides = isOverriddenOrOverrides;
            this.isExtends = isExtends;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = "Replace with '? " + (this.isExtends ? "extends" : "super") + "'";
            if (string == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiField field;
            PsiElement element;
            if (project == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PsiTypeElement && element.isValid() && element.getParent() != null && element.isPhysical())) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            VarianceCandidate candidate = VarianceCandidate.findVarianceCandidate(typeElement);
            if (candidate == null) {
                return;
            }
            PsiMethod method = candidate.method;
            PsiClassReferenceType clone = BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends);
            if (!this.isOverriddenOrOverrides) {
                PsiField field2 = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method);
                if (field2 != null) {
                    ReplaceWithQuestionTFix.replaceType(project, field2.getTypeElement(), (PsiType)BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends));
                }
                PsiTypeElement methodParameterTypeElement = candidate.methodParameter.getTypeElement();
                ReplaceWithQuestionTFix.replaceType(project, methodParameterTypeElement, (PsiType)clone);
                return;
            }
            int[] i = new int[]{0};
            List parameterInfos = ContainerUtil.map((Object[])method.getParameterList().getParameters(), p -> {
                int n = i[0];
                i[0] = n + 1;
                return new ParameterInfoImpl(n, p.getName(), p.getType());
            });
            int index = method.getParameterList().getParameterIndex(candidate.methodParameter);
            if (index == -1) {
                return;
            }
            PsiMethod superMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
            if (superMethod == null) {
                return;
            }
            if (superMethod != method) {
                method = superMethod;
                candidate = candidate.getSuperMethodVarianceCandidate(superMethod);
                clone = BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends);
                i[0] = 0;
                parameterInfos = ContainerUtil.map((Object[])superMethod.getParameterList().getParameters(), p -> {
                    int n = i[0];
                    i[0] = n + 1;
                    return new ParameterInfoImpl(n, p.getName(), p.getType());
                });
            }
            parameterInfos.set(index, new ParameterInfoImpl(index, candidate.methodParameter.getName(), (PsiType)clone));
            JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, false, null);
            dialog.setParameterInfos(parameterInfos);
            TransactionGuard.submitTransaction((Disposable)project, () -> dialog.show());
            if (dialog.getExitCode() == 0 && (field = BoundedWildcardInspection.findFieldAssignedFromMethodParameter(candidate.methodParameter, method)) != null) {
                ReplaceWithQuestionTFix.replaceType(project, field.getTypeElement(), (PsiType)BoundedWildcardInspection.suggestMethodParameterType(candidate, this.isExtends));
            }
        }

        private static void replaceType(@NotNull Project project, @NotNull PsiTypeElement typeElement, @NotNull PsiType withType) {
            if (project == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(3);
            }
            if (typeElement == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(4);
            }
            if (withType == null) {
                ReplaceWithQuestionTFix.$$$reportNull$$$0(5);
            }
            PsiElementFactory pf = PsiElementFactory.SERVICE.getInstance((Project)project);
            PsiTypeElement newTypeElement = pf.createTypeElement(withType);
            if (typeElement.isPhysical()) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    if (typeElement == null) {
                        ReplaceWithQuestionTFix.$$$reportNull$$$0(6);
                    }
                    typeElement.replace((PsiElement)newTypeElement);
                });
            } else {
                typeElement.replace((PsiElement)newTypeElement);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/BoundedWildcardInspection$ReplaceWithQuestionTFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "withType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/BoundedWildcardInspection$ReplaceWithQuestionTFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceType";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$replaceType$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

