/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertMessageNotStringInspection
extends BaseInspection {
    public boolean onlyWarnOnBoolean = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assert.message.not.string.display.name", new Object[0]);
        if (string == null) {
            AssertMessageNotStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("assert.message.of.type.boolean.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            AssertMessageNotStringInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assert.message.not.string.only.warn.boolean.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnBoolean");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertMessageNotStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/AssertMessageNotStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AssertMessageNotStringVisitor
    extends BaseInspectionVisitor {
        private AssertMessageNotStringVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression assertDescription = statement.getAssertDescription();
            if (assertDescription == null) {
                return;
            }
            PsiType type2 = assertDescription.getType();
            if (AssertMessageNotStringInspection.this.onlyWarnOnBoolean) {
                if (PsiType.BOOLEAN.equals((Object)type2)) {
                    this.registerError((PsiElement)assertDescription, type2);
                    return;
                }
                PsiClassType javaLangBoolean = PsiType.BOOLEAN.getBoxedType((PsiElement)statement);
                if (javaLangBoolean != null && javaLangBoolean.equals((Object)type2)) {
                    this.registerError((PsiElement)assertDescription, type2);
                }
            } else if (type2 != null && !type2.equalsToText("java.lang.String")) {
                this.registerError((PsiElement)assertDescription, type2);
            }
        }
    }
}

