/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayCreationWithoutNewKeywordInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.creation.without.new.keyword.name", new Object[0]);
        if (string == null) {
            ArrayCreationWithoutNewKeywordInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            ArrayCreationWithoutNewKeywordInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayCreationExpressionVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new ArrayCreationExpressionFix((String)infos[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ArrayCreationWithoutNewKeywordInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayCreationExpressionFix
    extends InspectionGadgetsFix {
        private final String myType;

        public ArrayCreationExpressionFix(String type2) {
            this.myType = type2;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("array.creation.without.new.keyword.quickfix", this.myType);
            if (string == null) {
                ArrayCreationExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("array.creation.without.new.keyword.family.quickfix", new Object[0]);
            if (string == null) {
                ArrayCreationExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiArrayInitializerExpression arrayInitializerExpression;
            PsiType type2;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiArrayInitializerExpression && (type2 = (arrayInitializerExpression = (PsiArrayInitializerExpression)element).getType()) != null) {
                PsiReplacementUtil.replaceExpression((PsiExpression)arrayInitializerExpression, "new " + TypeConversionUtil.erasure((PsiType)type2).getCanonicalText() + arrayInitializerExpression.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/ArrayCreationWithoutNewKeywordInspection$ArrayCreationExpressionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private ArrayCreationExpressionVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                String typeText = TypeConversionUtil.erasure((PsiType)type2).getCanonicalText();
                this.registerError((PsiElement)expression2, typeText);
            }
        }
    }
}

