/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SerialVersionUIDBuilder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import com.siyeh.ig.serialization.SerializableInspectionUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableCanHaveDefaultSerialUIDInspection
extends SerializableInspectionBase {
    public JComponent createOptionsPanel() {
        return SerializableInspectionUtil.createOptions(this);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.serializable.can.have.default.serial.uid", new Object[0]);
        if (string == null) {
            SerializableCanHaveDefaultSerialUIDInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeSerialUidToDefaultFix((Long)infos[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.serializable.can.have.default.serial.uid.message", new Object[0]);
        if (string == null) {
            SerializableCanHaveDefaultSerialUIDInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitField(PsiField field) {
                if (!"serialVersionUID".equals(field.getName())) {
                    return;
                }
                PsiExpression initializer = field.getInitializer();
                Object initializerResult = ExpressionUtils.computeConstantExpression(initializer);
                if (!(initializerResult instanceof Long)) {
                    return;
                }
                PsiClass aClass = field.getContainingClass();
                if (aClass == null) {
                    return;
                }
                if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.io.Serializable")) {
                    return;
                }
                long suid = SerialVersionUIDBuilder.computeDefaultSUID(aClass);
                if (((Number)initializerResult).longValue() == suid) {
                    return;
                }
                this.registerError((PsiElement)initializer, suid);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerializableCanHaveDefaultSerialUIDInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ChangeSerialUidToDefaultFix
    extends InspectionGadgetsFix {
        private final long mySerialUid;

        private ChangeSerialUidToDefaultFix(long uid) {
            this.mySerialUid = uid;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                ChangeSerialUidToDefaultFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.serializable.can.have.default.serial.uid.fix.name", new Object[0]);
            if (string == null) {
                ChangeSerialUidToDefaultFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            new CommentTracker().replaceAndRestoreComments(descriptor.getStartElement(), String.valueOf(this.mySerialUid) + "L");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/serialization/SerializableCanHaveDefaultSerialUIDInspection$ChangeSerialUidToDefaultFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

