/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableDeserializableClassInSecureContextInspection
extends BaseInspection {
    public boolean ignoreThrowable = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            SerializableDeserializableClassInSecureContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean serializable = (Boolean)infos[0];
        Boolean deserializable = (Boolean)infos[1];
        if (serializable.booleanValue()) {
            String string = deserializable != false ? InspectionGadgetsBundle.message("serializable.deserializable.class.in.secure.context.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("serializable.class.in.secure.context.problem.descriptor", new Object[0]);
            if (string == null) {
                SerializableDeserializableClassInSecureContextInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("deserializable.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            SerializableDeserializableClassInSecureContextInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean addWriteObjectMethod;
        Boolean serializable = (Boolean)infos[0];
        Boolean deserializable = (Boolean)infos[1];
        PsiClass aClass = (PsiClass)infos[2];
        boolean addReadObjectMethod = deserializable != false && !SerializableDeserializableClassInSecureContextInspection.hasOwnReadObjectMethod(aClass);
        boolean bl = addWriteObjectMethod = serializable != false && !SerializableDeserializableClassInSecureContextInspection.hasOwnWriteObjectMethod(aClass);
        if (!addReadObjectMethod && !addWriteObjectMethod) {
            return null;
        }
        return new AddReadWriteObjectMethodsFix(addReadObjectMethod, addWriteObjectMethod);
    }

    private static boolean hasOwnReadObjectMethod(PsiClass aClass) {
        return Arrays.stream(aClass.findMethodsByName("readObject", false)).anyMatch(SerializationUtils::isReadObject);
    }

    private static boolean hasOwnWriteObjectMethod(PsiClass aClass) {
        return Arrays.stream(aClass.findMethodsByName("writeObject", false)).anyMatch(SerializationUtils::isWriteObject);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.classes.extending.throwable.option", new Object[0]), (InspectionProfileEntry)this, "ignoreThrowable");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableDeserializableClassInSecureContextVisitor();
    }

    public String getAlternativeID() {
        return "serial";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/security/SerializableDeserializableClassInSecureContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SerializableDeserializableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private SerializableDeserializableClassInSecureContextVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            boolean deserializable;
            if (aClass == null) {
                SerializableDeserializableClassInSecureContextVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || !SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (SerializableDeserializableClassInSecureContextInspection.this.ignoreThrowable && InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.lang.Throwable")) {
                return;
            }
            if (!this.hasSerializableState(aClass)) {
                return;
            }
            boolean serializable = !this.hasWriteObjectMethodWhichAlwaysThrowsException(aClass);
            boolean bl = deserializable = !this.hasReadObjectMethodWhichAlwaysThrowsException(aClass);
            if (!serializable && !deserializable) {
                return;
            }
            this.registerClassError(aClass, serializable, deserializable, aClass);
        }

        private boolean hasSerializableState(PsiClass aClass) {
            return Arrays.stream(aClass.getFields()).filter(f -> !f.hasModifierProperty("static")).filter(f -> !f.hasModifierProperty("transient")).anyMatch(f -> !(f instanceof PsiEnumConstant));
        }

        private boolean hasReadObjectMethodWhichAlwaysThrowsException(PsiClass aClass) {
            for (PsiMethod method : aClass.findMethodsByName("readObject", true)) {
                if (!SerializationUtils.isReadObject(method)) continue;
                return ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement());
            }
            return false;
        }

        private boolean hasWriteObjectMethodWhichAlwaysThrowsException(PsiClass aClass) {
            for (PsiMethod method : aClass.findMethodsByName("writeObject", true)) {
                if (!SerializationUtils.isWriteObject(method)) continue;
                return ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/security/SerializableDeserializableClassInSecureContextInspection$SerializableDeserializableClassInSecureContextVisitor", "visitClass"));
        }
    }

    private static class AddReadWriteObjectMethodsFix
    extends InspectionGadgetsFix {
        private final boolean myReadObject;
        private final boolean myWriteObject;

        AddReadWriteObjectMethodsFix(boolean readObject, boolean writeObject) {
            this.myReadObject = readObject;
            this.myWriteObject = writeObject;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myReadObject) {
                String string = this.myWriteObject ? this.getFamilyName() : "Add 'readObject()' method which always throws exception";
                if (string == null) {
                    AddReadWriteObjectMethodsFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            if ("Add 'writeObject()' methods which always throws exception" == null) {
                AddReadWriteObjectMethodsFix.$$$reportNull$$$0(1);
            }
            return "Add 'writeObject()' methods which always throws exception";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Add 'readObject()' and 'writeObject()' methods which always throw exception" == null) {
                AddReadWriteObjectMethodsFix.$$$reportNull$$$0(2);
            }
            return "Add 'readObject()' and 'writeObject()' methods which always throw exception";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (this.myReadObject) {
                PsiMethod readObjectMethod = factory.createMethodFromText("private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {  throw new java.io.NotSerializableException(\"" + className + "\");}", (PsiElement)containingClass);
                containingClass.add((PsiElement)readObjectMethod);
            }
            if (this.myWriteObject) {
                PsiMethod writeObjectMethod = factory.createMethodFromText("private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {  throw new java.io.NotSerializableException(\"" + className + "\");}", (PsiElement)containingClass);
                containingClass.add((PsiElement)writeObjectMethod);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/security/SerializableDeserializableClassInSecureContextInspection$AddReadWriteObjectMethodsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

