/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    @NonNls
    private static final Set<String> keywordTable = new HashSet<String>();
    @NonNls
    private static final String AN = "an";

    private StringUtils() {
    }

    @NotNull
    public static String createSingularFromName(@NotNull String name) {
        if (name == null) {
            StringUtils.$$$reportNull$$$0(0);
        }
        int nameLength = name.length();
        String singularName = name.endsWith("ies") ? name.substring(0, nameLength - 3) + 'y' : (name.endsWith("sses") || name.endsWith("shes") ? name.substring(0, nameLength - 2) : (name.charAt(nameLength - 1) == 's' ? name.substring(0, nameLength - 1) : (name.endsWith("IES") ? name.substring(0, nameLength - 3) + 'Y' : (name.endsWith("SSES") || name.endsWith("SHES") ? name.substring(0, nameLength - 2) : (name.charAt(nameLength - 1) == 'S' ? name.substring(0, nameLength - 1) : StringUtils.prependIndefiniteArticle(name))))));
        if (keywordTable.contains(singularName)) {
            String string = StringUtils.prependIndefiniteArticle(singularName);
            if (string == null) {
                StringUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = singularName;
        if (string == null) {
            StringUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String prependIndefiniteArticle(String singularName) {
        switch (singularName.charAt(0)) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                String string = AN + StringUtil.capitalize((String)singularName);
                if (string == null) {
                    StringUtils.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = 'a' + StringUtil.capitalize((String)singularName);
        if (string == null) {
            StringUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String stripAngleBrackets(String string) {
        int index = string.indexOf(60);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    static {
        keywordTable.add("abstract");
        keywordTable.add("assert");
        keywordTable.add("boolean");
        keywordTable.add("break");
        keywordTable.add("byte");
        keywordTable.add("case");
        keywordTable.add("catch");
        keywordTable.add("char");
        keywordTable.add("class");
        keywordTable.add("const");
        keywordTable.add("continue");
        keywordTable.add("default");
        keywordTable.add("do");
        keywordTable.add("double");
        keywordTable.add("else");
        keywordTable.add("enum");
        keywordTable.add("extends");
        keywordTable.add("false");
        keywordTable.add("final");
        keywordTable.add("finally");
        keywordTable.add("float");
        keywordTable.add("for");
        keywordTable.add("goto");
        keywordTable.add("if");
        keywordTable.add("implements");
        keywordTable.add("import");
        keywordTable.add("instanceof");
        keywordTable.add("int");
        keywordTable.add("interface");
        keywordTable.add("long");
        keywordTable.add("native");
        keywordTable.add("new");
        keywordTable.add("null");
        keywordTable.add("package");
        keywordTable.add("private");
        keywordTable.add("protected");
        keywordTable.add("public");
        keywordTable.add("return");
        keywordTable.add("short");
        keywordTable.add("static");
        keywordTable.add("strictfp");
        keywordTable.add("super");
        keywordTable.add("switch");
        keywordTable.add("synchronized");
        keywordTable.add("this");
        keywordTable.add("throw");
        keywordTable.add("throws");
        keywordTable.add("transient");
        keywordTable.add("true");
        keywordTable.add("try");
        keywordTable.add("void");
        keywordTable.add("volatile");
        keywordTable.add("while");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/StringUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/StringUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingularFromName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prependIndefiniteArticle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSingularFromName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

