/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ConstructionUtils {
    private static final Set<String> GUAVA_UTILITY_CLASSES = ContainerUtil.set((Object[])new String[]{"com.google.common.collect.Maps", "com.google.common.collect.Lists", "com.google.common.collect.Sets"});
    private static final CallMatcher ENUM_SET_NONE_OF = CallMatcher.staticCall("java.util.EnumSet", "noneOf").parameterCount(1);

    @Contract(value="null -> false")
    public static boolean isEmptyStringBuilderInitializer(PsiExpression initializer) {
        return "\"\"".equals(ConstructionUtils.getStringBuilderInitializerText(initializer));
    }

    @Contract(value="null -> null")
    public static String getStringBuilderInitializerText(PsiExpression construction) {
        if (!((construction = PsiUtil.skipParenthesizedExprDown((PsiExpression)construction)) instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)construction;
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        if (!ConstructionUtils.isReferenceTo(classReference2, "java.lang.StringBuilder", "java.lang.StringBuffer")) {
            return null;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return "\"\"";
        }
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        PsiType argumentType = argument.getType();
        if (PsiType.INT.equals((Object)argumentType)) {
            return "\"\"";
        }
        return argument.getText();
    }

    @Contract(value="null -> false")
    public static boolean isEmptyCollectionInitializer(PsiExpression expression2) {
        PsiExpressionList argumentList;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)expression2).getArgumentList()) != null && argumentList.isEmpty()) {
            PsiType type2 = expression2.getType();
            return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList2 = call.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList2.isEmpty() && (method = call.resolveMethod()) != null && method.getParameterList().isEmpty() && (aClass = method.getContainingClass()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName = aClass.getQualifiedName())) {
                return true;
            }
        }
        return ConstructionUtils.isCustomizedEmptyCollectionInitializer(expression2);
    }

    public static boolean isPrepopulatedCollectionInitializer(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiNewExpression) {
            PsiExpressionList args = ((PsiNewExpression)expression2).getArgumentList();
            if (args == null || args.isEmpty()) {
                return false;
            }
            PsiMethod ctor = ((PsiNewExpression)expression2).resolveMethod();
            if (ctor == null) {
                return false;
            }
            PsiClass aClass = ctor.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String name = aClass.getQualifiedName();
            if (name == null || !name.startsWith("java.util.")) {
                return false;
            }
            for (PsiParameter parameter2 : ctor.getParameterList().getParameters()) {
                PsiClassType rawType;
                PsiType type2 = parameter2.getType();
                if (!(type2 instanceof PsiClassType) || !(rawType = ((PsiClassType)type2).rawType()).equalsToText("java.util.Collection") && !rawType.equalsToText("java.util.Map")) continue;
                return true;
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList = call.getArgumentList();
            if (name != null && name.startsWith("new") && !argumentList.isEmpty()) {
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return false;
                }
                String qualifiedName = aClass.getQualifiedName();
                if (!GUAVA_UTILITY_CLASSES.contains(qualifiedName)) {
                    return false;
                }
                for (PsiParameter parameter3 : method.getParameterList().getParameters()) {
                    PsiClassType rawType;
                    PsiType type3 = parameter3.getType();
                    if (type3 instanceof PsiEllipsisType) {
                        return true;
                    }
                    if (!(type3 instanceof PsiClassType) || !(rawType = ((PsiClassType)type3).rawType()).equalsToText("java.lang.Iterable") && !rawType.equalsToText("java.util.Iterator")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isCustomizedEmptyCollectionInitializer(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiNewExpression) {
            PsiExpressionList argumentList = ((PsiNewExpression)expression2).getArgumentList();
            if (argumentList == null || argumentList.isEmpty()) {
                return false;
            }
            PsiMethod constructor = ((PsiNewExpression)expression2).resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (!(aClass == null || aClass.getQualifiedName() != null && aClass.getQualifiedName().startsWith("java.util."))) {
                return false;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map")) {
                return false;
            }
            Predicate<PsiType> allowedParameterType = t -> t instanceof PsiPrimitiveType || InheritanceUtil.isInheritor((PsiType)t, (String)"java.lang.Class");
            return Stream.of(constructor.getParameterList().getParameters()).map(PsiParameter::getType).allMatch(allowedParameterType);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (ENUM_SET_NONE_OF.test(call)) {
                return true;
            }
            String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList = call.getArgumentList();
            if (name != null && name.startsWith("new") && !argumentList.isEmpty() && (method = call.resolveMethod()) != null && !method.getParameterList().isEmpty() && (aClass = method.getContainingClass()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName = aClass.getQualifiedName())) {
                return Stream.of(method.getParameterList().getParameters()).allMatch(p -> p.getType() instanceof PsiPrimitiveType);
            }
        }
        return false;
    }

    public static boolean isEmptyArrayInitializer(@Nullable PsiExpression expression2) {
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression2;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return false;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            return initializers.length == 0;
        }
        for (PsiExpression dimension : dimensions) {
            String dimensionText = dimension.getText();
            if ("0".equals(dimensionText)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReferenceTo(PsiJavaCodeReferenceElement ref, String ... classNames) {
        if (ref == null) {
            return false;
        }
        String name = ref.getReferenceName();
        if (name == null) {
            return false;
        }
        String qualifiedName = null;
        for (String className : classNames) {
            if (!StringUtil.getShortName((String)className).equals(name)) continue;
            if (qualifiedName == null) {
                qualifiedName = ref.getQualifiedName();
            }
            if (!className.equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isCollectionWithCopyConstructor(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        String name = aClass.getQualifiedName();
        return name != null && name.startsWith("java.util.") && Stream.of(aClass.getConstructors()).anyMatch(ConstructionUtils::isCollectionConstructor);
    }

    @Contract(value="null -> false")
    private static boolean isCollectionConstructor(PsiMethod ctor) {
        if (ctor == null || !ctor.getModifierList().hasExplicitModifier("public")) {
            return false;
        }
        PsiParameterList list = ctor.getParameterList();
        if (list.getParametersCount() != 1) {
            return false;
        }
        PsiTypeElement typeElement = list.getParameters()[0].getTypeElement();
        if (typeElement == null) {
            return false;
        }
        PsiType type2 = typeElement.getType();
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return aClass != null && ("java.util.Collection".equals(aClass.getQualifiedName()) || "java.util.Map".equals(aClass.getQualifiedName()));
    }
}

