/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonUtils {
    private static final Set<IElementType> s_comparisonTokens = new HashSet<IElementType>(6);
    private static final Map<IElementType, String> s_swappedComparisons = new HashMap<IElementType, String>(6);
    private static final Map<IElementType, String> s_invertedComparisons = new HashMap<IElementType, String>(6);

    private ComparisonUtils() {
    }

    public static boolean isComparison(@Nullable PsiExpression expression2) {
        if (!(expression2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        return ComparisonUtils.isComparisonOperation(tokenType);
    }

    public static boolean isComparisonOperation(IElementType tokenType) {
        return s_comparisonTokens.contains(tokenType);
    }

    public static String getFlippedComparison(IElementType tokenType) {
        return s_swappedComparisons.get(tokenType);
    }

    public static boolean isEqualityComparison(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ComparisonUtils.$$$reportNull$$$0(0);
        }
        if (!(expression2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        return tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE);
    }

    public static String getNegatedComparison(IElementType tokenType) {
        return s_invertedComparisons.get(tokenType);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isNullComparison(PsiExpression expression2, @NotNull PsiVariable variable, boolean equal) {
        if (variable == null) {
            ComparisonUtils.$$$reportNull$$$0(1);
        }
        return variable.equals(ExpressionUtils.getVariableFromNullComparison(expression2, equal));
    }

    @Contract(value="null -> false")
    public static boolean isNullComparison(PsiExpression expression2) {
        return expression2 instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)expression2) != null;
    }

    static {
        s_comparisonTokens.add(JavaTokenType.EQEQ);
        s_comparisonTokens.add(JavaTokenType.NE);
        s_comparisonTokens.add(JavaTokenType.GT);
        s_comparisonTokens.add(JavaTokenType.LT);
        s_comparisonTokens.add(JavaTokenType.GE);
        s_comparisonTokens.add(JavaTokenType.LE);
        s_swappedComparisons.put(JavaTokenType.EQEQ, "==");
        s_swappedComparisons.put(JavaTokenType.NE, "!=");
        s_swappedComparisons.put(JavaTokenType.GT, "<");
        s_swappedComparisons.put(JavaTokenType.LT, ">");
        s_swappedComparisons.put(JavaTokenType.GE, "<=");
        s_swappedComparisons.put(JavaTokenType.LE, ">=");
        s_invertedComparisons.put(JavaTokenType.EQEQ, "!=");
        s_invertedComparisons.put(JavaTokenType.NE, "==");
        s_invertedComparisons.put(JavaTokenType.GT, "<=");
        s_invertedComparisons.put(JavaTokenType.LT, ">=");
        s_invertedComparisons.put(JavaTokenType.GE, "<");
        s_invertedComparisons.put(JavaTokenType.LE, ">");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/ComparisonUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualityComparison";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNullComparison";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

