/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CommentTracker {
    private final Set<PsiElement> ignoredParents = new HashSet<PsiElement>();
    private List<PsiComment> comments = new ArrayList<PsiComment>();

    @NotNull
    public String text(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(0);
        }
        this.checkState();
        this.addIgnored(element);
        String string = element.getText();
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String text(@NotNull PsiExpression element, int precedence) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(2);
        }
        this.checkState();
        this.addIgnored((PsiElement)element);
        String string = ParenthesesUtils.getText(element, precedence + 1);
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String lambdaText(@NotNull PsiVariable variable, @NotNull PsiExpression expression2) {
        if (variable == null) {
            CommentTracker.$$$reportNull$$$0(4);
        }
        if (expression2 == null) {
            CommentTracker.$$$reportNull$$$0(5);
        }
        String string = variable.getName() + " -> " + this.text((PsiElement)expression2);
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public <T extends PsiElement> T markUnchanged(@NotNull T element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(7);
        }
        this.checkState();
        this.addIgnored(element);
        T t = element;
        if (t == null) {
            CommentTracker.$$$reportNull$$$0(8);
        }
        return t;
    }

    public String rangeText(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        PsiElement e;
        if (firstElement == null) {
            CommentTracker.$$$reportNull$$$0(9);
        }
        if (lastElement == null) {
            CommentTracker.$$$reportNull$$$0(10);
        }
        this.checkState();
        StringBuilder result = new StringBuilder();
        for (e = firstElement; e != null && e != lastElement; e = e.getNextSibling()) {
            this.addIgnored(e);
            result.append(e.getText());
        }
        if (e == null) {
            throw new IllegalArgumentException("Elements must be siblings: " + firstElement + " and " + lastElement);
        }
        this.addIgnored(lastElement);
        result.append(lastElement.getText());
        return result.toString();
    }

    public void markRangeUnchanged(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        PsiElement e;
        if (firstElement == null) {
            CommentTracker.$$$reportNull$$$0(11);
        }
        if (lastElement == null) {
            CommentTracker.$$$reportNull$$$0(12);
        }
        this.checkState();
        for (e = firstElement; e != null && e != lastElement; e = e.getNextSibling()) {
            this.addIgnored(e);
        }
        if (e == null) {
            throw new IllegalArgumentException("Elements must be siblings: " + firstElement + " and " + lastElement);
        }
        this.addIgnored(lastElement);
    }

    public void delete(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(13);
        }
        this.grabCommentsOnDelete(element);
        element.delete();
    }

    public void delete(PsiElement ... elements) {
        if (elements == null) {
            CommentTracker.$$$reportNull$$$0(14);
        }
        for (PsiElement element : elements) {
            this.delete(element);
        }
    }

    public void deleteAndRestoreComments(@NotNull PsiElement element) {
        PsiElement anchor;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(15);
        }
        this.grabCommentsOnDelete(element);
        for (anchor = element; anchor.getParent() != null && !(anchor.getParent() instanceof PsiFile) && anchor.getParent().getFirstChild() == anchor; anchor = anchor.getParent()) {
        }
        this.insertCommentsBefore(anchor);
        element.delete();
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(16);
        }
        if (replacement == null) {
            CommentTracker.$$$reportNull$$$0(17);
        }
        this.grabComments(element);
        PsiElement psiElement = element.replace(replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull String text2) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            CommentTracker.$$$reportNull$$$0(20);
        }
        PsiElement replacement = CommentTracker.createElement(element, text2);
        PsiElement psiElement = this.replace(element, replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        PsiElement result;
        PsiElement anchor;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(22);
        }
        if (replacement == null) {
            CommentTracker.$$$reportNull$$$0(23);
        }
        if ((anchor = PsiTreeUtil.getNonStrictParentOfType((PsiElement)(result = this.replace(element, replacement)), (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class, PsiVariable.class})) instanceof PsiLambdaExpression && anchor != result) {
            anchor = ((PsiLambdaExpression)anchor).getBody();
        }
        if (anchor instanceof PsiVariable && anchor.getParent() instanceof PsiDeclarationStatement) {
            anchor = anchor.getParent();
        }
        if (anchor instanceof PsiStatement && (anchor.getParent() instanceof PsiIfStatement || anchor.getParent() instanceof PsiLoopStatement)) {
            anchor = anchor.getParent();
        }
        if (anchor == null) {
            anchor = result;
        }
        this.insertCommentsBefore(anchor);
        PsiElement psiElement = result;
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull String text2) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            CommentTracker.$$$reportNull$$$0(26);
        }
        PsiElement replacement = CommentTracker.createElement(element, text2);
        PsiElement psiElement = this.replaceAndRestoreComments(element, replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(27);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement createElement(@NotNull PsiElement element, @NotNull String text2) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            CommentTracker.$$$reportNull$$$0(29);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        if (element instanceof PsiExpression) {
            PsiExpression psiExpression = factory.createExpressionFromText(text2, element);
            if (psiExpression == null) {
                CommentTracker.$$$reportNull$$$0(30);
            }
            return psiExpression;
        }
        if (element instanceof PsiStatement) {
            PsiStatement psiStatement = factory.createStatementFromText(text2, element);
            if (psiStatement == null) {
                CommentTracker.$$$reportNull$$$0(31);
            }
            return psiStatement;
        }
        if (element instanceof PsiTypeElement) {
            PsiTypeElement psiTypeElement = factory.createTypeElementFromText(text2, element);
            if (psiTypeElement == null) {
                CommentTracker.$$$reportNull$$$0(32);
            }
            return psiTypeElement;
        }
        if (element instanceof PsiIdentifier) {
            PsiIdentifier psiIdentifier = factory.createIdentifier(text2);
            if (psiIdentifier == null) {
                CommentTracker.$$$reportNull$$$0(33);
            }
            return psiIdentifier;
        }
        if (element instanceof PsiComment) {
            PsiComment psiComment = factory.createCommentFromText(text2, element);
            if (psiComment == null) {
                CommentTracker.$$$reportNull$$$0(34);
            }
            return psiComment;
        }
        throw new IllegalArgumentException("Unsupported element type: " + element);
    }

    public void insertCommentsBefore(@NotNull PsiElement anchor) {
        if (anchor == null) {
            CommentTracker.$$$reportNull$$$0(35);
        }
        this.checkState();
        if (!this.comments.isEmpty()) {
            PsiElement parent = anchor.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            for (PsiComment comment : this.comments) {
                PsiElement added;
                PsiElement prevSibling;
                if (this.shouldIgnore(comment) || !((prevSibling = (added = parent.addBefore((PsiElement)factory.createCommentFromText(comment.getText(), anchor), anchor)).getPrevSibling()) instanceof PsiWhiteSpace)) continue;
                PsiElement prev = anchor.getPrevSibling();
                ASTNode whiteSpaceBefore = CommentTracker.normalizeWhiteSpace((PsiWhiteSpace)prevSibling, prev);
                parent.getNode().addChild(whiteSpaceBefore, anchor.getNode());
                if (!(prev instanceof PsiWhiteSpace)) continue;
                prev.delete();
            }
        }
        this.comments = null;
    }

    @NotNull
    private static ASTNode normalizeWhiteSpace(PsiWhiteSpace whiteSpace, PsiElement nextElement) {
        int endLPos;
        String text2 = whiteSpace.getText();
        if (text2.lastIndexOf(10, (endLPos = text2.lastIndexOf(10)) - 1) >= 0) {
            LeafElement leafElement = ASTFactory.whitespace((CharSequence)text2.substring(endLPos));
            if (leafElement == null) {
                CommentTracker.$$$reportNull$$$0(36);
            }
            return leafElement;
        }
        if (nextElement instanceof PsiWhiteSpace && nextElement.getText().contains("\n") && !text2.contains("\n")) {
            text2 = '\n' + text2;
        }
        LeafElement leafElement = ASTFactory.whitespace((CharSequence)text2);
        if (leafElement == null) {
            CommentTracker.$$$reportNull$$$0(37);
        }
        return leafElement;
    }

    private boolean shouldIgnore(PsiComment comment) {
        return this.ignoredParents.stream().anyMatch(p -> PsiTreeUtil.isAncestor((PsiElement)p, (PsiElement)comment, (boolean)false));
    }

    private void grabCommentsOnDelete(PsiElement element) {
        if (element instanceof PsiExpression && element.getParent() instanceof PsiExpressionStatement || element.getParent() instanceof PsiJavaCodeReferenceElement) {
            element = element.getParent();
        }
        this.grabComments(element);
        if (element instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, PsiComment.class).forEach(PsiElement::delete);
        }
    }

    private void grabComments(PsiElement element) {
        this.checkState();
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class})) {
            if (this.shouldIgnore(comment)) continue;
            this.comments.add(comment);
        }
    }

    private void checkState() {
        if (this.comments == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already used");
        }
    }

    private void addIgnored(PsiElement element) {
        if (!(element instanceof LeafPsiElement) || element instanceof PsiComment) {
            this.ignoredParents.add(element);
        }
    }

    public static String textWithSurroundingComments(PsiElement element) {
        Predicate<PsiElement> commentOrWhiteSpace = e -> e instanceof PsiComment || e instanceof PsiWhiteSpace;
        List prev = StreamEx.iterate((Object)element.getPrevSibling(), commentOrWhiteSpace, PsiElement::getPrevSibling).toList();
        List next = StreamEx.iterate((Object)element.getNextSibling(), commentOrWhiteSpace, PsiElement::getNextSibling).toList();
        if (StreamEx.of((Object[])new List[]{prev, next}).flatCollection(Function.identity()).anyMatch(PsiComment.class::isInstance)) {
            return StreamEx.ofReversed((List)prev).append((Object)element).append((Collection)next).map(PsiElement::getText).joining();
        }
        return element.getText();
    }

    @NotNull
    public static String commentsBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        PsiElement parent;
        if (start == null) {
            CommentTracker.$$$reportNull$$$0(38);
        }
        if (end == null) {
            CommentTracker.$$$reportNull$$$0(39);
        }
        if ((parent = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end)) == null) {
            throw new IllegalStateException("Common parent is not found: [" + start + ".." + end + "]");
        }
        PsiElement cur = CommentTracker.next(start, parent);
        ArrayList<Object> comments = new ArrayList<Object>();
        while (cur != null && !PsiTreeUtil.isAncestor((PsiElement)cur, (PsiElement)end, (boolean)false)) {
            comments.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)cur, PsiComment.class));
            if (cur instanceof PsiComment) {
                comments.add((PsiComment)cur);
            }
            cur = CommentTracker.next(cur, parent);
        }
        if (cur == null) {
            throw new IllegalStateException("End is not reached: [" + start + ".." + end + "]");
        }
        PsiElement tail = CommentTracker.prev(end, cur);
        ArrayDeque tailComments = new ArrayDeque();
        while (tail != null) {
            PsiTreeUtil.findChildrenOfType((PsiElement)tail, PsiComment.class).forEach(tailComments::addFirst);
            if (cur instanceof PsiComment) {
                comments.add((PsiComment)cur);
            }
            tail = CommentTracker.prev(tail, cur);
        }
        comments.addAll(tailComments);
        StringBuilder sb = new StringBuilder();
        for (PsiComment psiComment : comments) {
            PsiElement prev = CommentTracker.prev((PsiElement)psiComment, parent);
            if (prev instanceof PsiWhiteSpace) {
                sb.append(prev.getText());
            }
            sb.append(psiComment.getText());
            PsiElement next = CommentTracker.next((PsiElement)psiComment, parent);
            if (next instanceof PsiWhiteSpace) {
                sb.append(next.getText());
            }
            psiComment.delete();
        }
        String string = sb.toString();
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static PsiElement next(PsiElement cur, PsiElement stopAtParent) {
        if (cur == stopAtParent) {
            return null;
        }
        PsiElement next = cur.getNextSibling();
        if (next != null) {
            return next;
        }
        PsiElement parent = cur.getParent();
        if (parent == stopAtParent) {
            return null;
        }
        return CommentTracker.next(parent, stopAtParent);
    }

    private static PsiElement prev(PsiElement cur, PsiElement stopAtParent) {
        if (cur == stopAtParent) {
            return null;
        }
        PsiElement prev = cur.getPrevSibling();
        if (prev != null) {
            return prev;
        }
        PsiElement parent = cur.getParent();
        if (parent == stopAtParent || parent == null) {
            return null;
        }
        return CommentTracker.prev(parent, stopAtParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/CommentTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 20: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/CommentTracker";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "text";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lambdaText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "markUnchanged";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAndRestoreComments";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeWhiteSpace";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "commentsBetween";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambdaText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markUnchanged";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rangeText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "markRangeUnchanged";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deleteAndRestoreComments";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceAndRestoreComments";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "insertCommentsBefore";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "commentsBetween";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

