/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryTemporaryOnConversionToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.to.string.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker());
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.problem.descriptor", replacementString);
        if (string == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(@NotNull PsiMethodCallExpression expression2, @NotNull CommentTracker commentTracker) {
        PsiReferenceExpression methodExpression;
        PsiNewExpression qualifier;
        if (expression2 == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(2);
        }
        if (commentTracker == null) {
            UnnecessaryTemporaryOnConversionToStringInspection.$$$reportNull$$$0(3);
        }
        if ((qualifier = (PsiNewExpression)ObjectUtils.tryCast((Object)(methodExpression = expression2.getMethodExpression()).getQualifierExpression(), PsiNewExpression.class)) == null) {
            return null;
        }
        PsiExpressionList argumentList = qualifier.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return null;
        }
        String argumentText = commentTracker.text((PsiElement)arguments[0]);
        String qualifierType = type2.getPresentableText();
        return qualifierType + ".toString(" + argumentText + ')';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker());
        String name = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.fix.name", replacement);
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateReplacementExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> s_basicTypes = new HashSet<String>(8);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                UnnecessaryTemporaryObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length < 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType != null && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return;
            }
            String typeName = type2.getCanonicalText();
            if (!s_basicTypes.contains(typeName)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        static {
            s_basicTypes.add("java.lang.Boolean");
            s_basicTypes.add("java.lang.Byte");
            s_basicTypes.add("java.lang.Character");
            s_basicTypes.add("java.lang.Double");
            s_basicTypes.add("java.lang.Float");
            s_basicTypes.add("java.lang.Integer");
            s_basicTypes.add("java.lang.Long");
            s_basicTypes.add("java.lang.Short");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectVisitor", "visitMethodCallExpression"));
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            CommentTracker commentTracker;
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)descriptor.getPsiElement();
            String newExpression = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression(expression2, commentTracker = new CommentTracker());
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

