/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ObjectAllocationInLoopInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.allocation.in.loop.display.name", new Object[0]);
        if (string == null) {
            ObjectAllocationInLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean direct = (Boolean)infos[0];
        String string = InspectionGadgetsBundle.message(direct ? "object.allocation.in.loop.problem.descriptor" : "object.allocation.in.loop.problem.indirect.descriptor", new Object[0]);
        if (string == null) {
            ObjectAllocationInLoopInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectAllocationInLoopsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ObjectAllocationInLoopInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ObjectAllocationInLoopsVisitor
    extends BaseInspectionVisitor {
        private ObjectAllocationInLoopsVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                List<StandardMethodContract> contracts2 = JavaMethodContractUtil.getMethodContracts(method);
                ContractReturnValue value2 = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
                if (ContractReturnValue.returnNew().equals(value2) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)call)) {
                    this.registerMethodCallError(call, false);
                }
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            if (ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression2)) {
                this.registerNewExpressionError(expression2, true);
            }
        }

        private static boolean isPerformedRepeatedlyInLoop(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                ObjectAllocationInLoopsVisitor.$$$reportNull$$$0(1);
            }
            if (!ControlFlowUtils.isInLoop((PsiElement)expression2)) {
                return false;
            }
            if (ControlFlowUtils.isInExitStatement(expression2)) {
                return false;
            }
            PsiStatement newExpressionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
            if (newExpressionStatement == null) {
                return false;
            }
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpressionStatement, PsiStatement.class);
            if (!ControlFlowUtils.statementMayCompleteNormally(parentStatement)) {
                return false;
            }
            return !ObjectAllocationInLoopsVisitor.isAllocatedOnlyOnce(expression2);
        }

        private static boolean isAllocatedOnlyOnce(PsiExpression expression2) {
            boolean equals;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiAssignmentExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            if (assignment == null) {
                return false;
            }
            PsiReferenceExpression assignedRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (assignedRef == null) {
                return false;
            }
            if (assignment.getRExpression() != expression2 && NullabilityUtil.getExpressionNullability(assignment.getRExpression()) != Nullability.NOT_NULL) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)assignment, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)assignment, (boolean)true)) {
                equals = true;
            } else if (PsiTreeUtil.isAncestor((PsiElement)ifStatement.getElseBranch(), (PsiElement)assignment, (boolean)true)) {
                equals = false;
            } else {
                return false;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            PsiReferenceExpression nullCheckedRef = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, equals);
            return nullCheckedRef != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullCheckedRef, (PsiElement)assignedRef);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/performance/ObjectAllocationInLoopInspection$ObjectAllocationInLoopsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPerformedRepeatedlyInLoop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

