/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.InlineCallFix;
import com.siyeh.ig.performance.CallToSimpleGetterInClassInspectionBase;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class CallToSimpleGetterInClassInspection
extends CallToSimpleGetterInClassInspectionBase {
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.simple.getter.in.class.ignore.option", new Object[0]), "ignoreGetterCallsOnOtherObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.private.simple.getter.in.class.option", new Object[0]), "onlyReportPrivateGetter");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineOrDeleteCallFix(InspectionGadgetsBundle.message("call.to.simple.getter.in.class.inline.quickfix", new Object[0]));
    }

    private static class InlineOrDeleteCallFix
    extends InlineCallFix {
        public InlineOrDeleteCallFix(String name) {
            super(name);
        }

        @Override
        protected void inline(Project project, PsiReferenceExpression methodExpression, PsiMethod method) {
            PsiElement statement = methodExpression.getParent().getParent();
            if (statement instanceof PsiExpressionStatement) {
                statement.delete();
            } else {
                super.inline(project, methodExpression, method);
            }
        }
    }
}

