/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisjointPackageInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("disjoint.package.display.name", new Object[0]);
        if (string == null) {
            DisjointPackageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            DisjointPackageInspection.$$$reportNull$$$0(1);
        }
        if (analysisScope == null) {
            DisjointPackageInspection.$$$reportNull$$$0(2);
        }
        if (inspectionManager == null) {
            DisjointPackageInspection.$$$reportNull$$$0(3);
        }
        if (globalInspectionContext == null) {
            DisjointPackageInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        List children = refPackage.getChildren();
        HashSet<RefClass> childClasses = new HashSet<RefClass>();
        for (RefEntity child : children) {
            PsiClass psiClass;
            if (!(child instanceof RefClass) || ClassUtils.isInnerClass(psiClass = ((RefClass)child).getElement())) continue;
            childClasses.add((RefClass)child);
        }
        if (childClasses.isEmpty()) {
            return null;
        }
        Set<Set<RefClass>> components = DisjointPackageInspection.createComponents(refPackage, childClasses);
        if (components.size() == 1) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("disjoint.package.problem.descriptor", refPackage.getQualifiedName(), components.size());
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static Set<Set<RefClass>> createComponents(RefPackage aPackage, Set<RefClass> classes2) {
        HashSet<RefClass> allClasses = new HashSet<RefClass>(classes2);
        HashSet<Set<RefClass>> out = new HashSet<Set<RefClass>>();
        while (!allClasses.isEmpty()) {
            RefClass seed = (RefClass)allClasses.iterator().next();
            allClasses.remove(seed);
            HashSet<RefClass> currentComponent = new HashSet<RefClass>();
            currentComponent.add(seed);
            ArrayList<RefClass> pendingClasses = new ArrayList<RefClass>();
            pendingClasses.add(seed);
            while (!pendingClasses.isEmpty()) {
                RefClass classToProcess = (RefClass)pendingClasses.remove(0);
                Set<RefClass> relatedClasses = DisjointPackageInspection.getRelatedClasses(aPackage, classToProcess);
                for (RefClass relatedClass : relatedClasses) {
                    if (currentComponent.contains(relatedClass) || pendingClasses.contains(relatedClass)) continue;
                    currentComponent.add(relatedClass);
                    pendingClasses.add(relatedClass);
                    allClasses.remove(relatedClass);
                }
            }
            out.add(currentComponent);
        }
        return out;
    }

    private static Set<RefClass> getRelatedClasses(RefPackage aPackage, RefClass classToProcess) {
        HashSet<RefClass> out = new HashSet<RefClass>();
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(classToProcess);
        for (RefClass dependency : dependencies) {
            if (!DisjointPackageInspection.packageContainsClass(aPackage, dependency)) continue;
            out.add(dependency);
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(classToProcess);
        for (RefClass dependent : dependents) {
            if (!DisjointPackageInspection.packageContainsClass(aPackage, dependent)) continue;
            out.add(dependent);
        }
        return out;
    }

    private static boolean packageContainsClass(RefPackage aPackage, RefClass aClass) {
        return aPackage.equals(RefJavaUtil.getPackage((RefEntity)aClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/packaging/DisjointPackageInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/packaging/DisjointPackageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

