/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class MakePublicStaticFix
extends InspectionGadgetsFix {
    private final String myName;
    private final boolean myMakeStatic;

    public MakePublicStaticFix(String name, boolean makeStatic) {
        this.myName = name;
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)parent;
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("public", true);
        modifierList.setModifierProperty("static", this.myMakeStatic);
        PsiElement sibling = modifierList.getNextSibling();
        if (sibling instanceof PsiWhiteSpace && sibling.getText().contains("\n")) {
            sibling.replace(PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText(" "));
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            MakePublicStaticFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Make public/static" == null) {
            MakePublicStaticFix.$$$reportNull$$$0(1);
        }
        return "Make public/static";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/MakePublicStaticFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

