/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitDefaultCharsetUsageInspection
extends BaseInspection {
    private static final Key<Boolean> HAS_CHARSET_OVERLOAD = Key.create((String)"Method has Charset overload");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.display.name", new Object[0]);
        if (string == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos[0] instanceof PsiNewExpression) {
            String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Contract(value="null -> false")
    private static boolean hasCharsetOverload(PsiMethod method) {
        if (method == null) {
            return false;
        }
        Boolean hasCharsetOverload = (Boolean)method.getUserData(HAS_CHARSET_OVERLOAD);
        if (hasCharsetOverload == null) {
            PsiMethod methodWithCharsetArgument = null;
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                PsiClassType charsetType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeByFQClassName("java.nio.charset.Charset", method.getResolveScope());
                MethodSignature newSignature = MethodSignatureUtil.createMethodSignature((String)signature.getName(), (PsiType[])((PsiType[])ArrayUtil.append((Object[])signature.getParameterTypes(), (Object)charsetType)), (PsiTypeParameter[])signature.getTypeParameters(), (PsiSubstitutor)signature.getSubstitutor(), (boolean)signature.isConstructor());
                methodWithCharsetArgument = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)newSignature, (boolean)false);
            }
            hasCharsetOverload = methodWithCharsetArgument != null;
            method.putUserData(HAS_CHARSET_OVERLOAD, (Object)hasCharsetOverload);
        }
        return hasCharsetOverload;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiCallExpression call = (PsiCallExpression)infos[0];
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)call)) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        return ImplicitDefaultCharsetUsageInspection.hasCharsetOverload(method) ? new AddUtf8CharsetFix() : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitDefaultCharsetUsageVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AddUtf8CharsetFix
    extends InspectionGadgetsFix {
        private AddUtf8CharsetFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiCallExpression call = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpressionList arguments = call.getArgumentList();
            if (arguments == null) {
                return;
            }
            PsiExpression charsetArg = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.nio.charset.StandardCharsets.UTF_8", (PsiElement)call);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(arguments.add((PsiElement)charsetArg));
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.fix.family.name", new Object[0]);
            if (string == null) {
                AddUtf8CharsetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection$AddUtf8CharsetFix", "getFamilyName"));
        }
    }

    private static class ImplicitDefaultCharsetUsageVisitor
    extends BaseInspectionVisitor {
        private ImplicitDefaultCharsetUsageVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"getBytes".equals(name)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 1) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qName = aClass.getQualifiedName();
            if (!"java.lang.String".equals(qName)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int count = parameterList.getParametersCount();
            if (count == 0) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            String qName = aClass.getQualifiedName();
            if ("java.lang.String".equals(qName)) {
                if (!parameters2[0].getType().equalsToText("byte[]") || ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[count - 1])) {
                    return;
                }
            } else if ("java.io.InputStreamReader".equals(qName) || "java.io.OutputStreamWriter".equals(qName) || "java.io.PrintStream".equals(qName)) {
                if (ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[count - 1])) {
                    return;
                }
            } else if ("java.io.PrintWriter".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[count - 1]) || parameters2[0].getType().equalsToText("java.io.Writer")) {
                    return;
                }
            } else if ("java.util.Formatter".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[1])) {
                    return;
                }
                PsiType firstType = parameters2[0].getType();
                if (!(firstType.equalsToText("java.lang.String") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.io.OutputStream"))) {
                    return;
                }
            } else if ("java.util.Scanner".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters2[1])) {
                    return;
                }
                PsiType firstType = parameters2[0].getType();
                if (!(firstType.equalsToText("java.io.InputStream") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.nio.file.Path") || firstType.equalsToText("java.nio.channels.ReadableByteChannel"))) {
                    return;
                }
            } else if (!"java.io.FileReader".equals(qName) && !"java.io.FileWriter".equals(qName)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private static boolean hasCharsetType(PsiVariable variable) {
            return TypeUtils.variableHasTypeOrSubtype(variable, "java.lang.String", "java.nio.charset.Charset", "java.nio.charset.CharsetEncoder", "java.nio.charset.CharsetDecoder");
        }
    }
}

