/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IgnoreClassFix
extends InspectionGadgetsFix
implements LowPriorityAction {
    final Collection<String> myIgnoredClasses;
    final String myQualifiedName;
    private final String myFixName;

    public IgnoreClassFix(String qualifiedName, Collection<String> ignoredClasses, String fixName) {
        this.myIgnoredClasses = ignoredClasses;
        this.myQualifiedName = qualifiedName;
        this.myFixName = fixName;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myFixName;
        if (string == null) {
            IgnoreClassFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Ignore for these types" == null) {
            IgnoreClassFix.$$$reportNull$$$0(1);
        }
        return "Ignore for these types";
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doFix(final Project project, ProblemDescriptor descriptor) {
        if (!this.myIgnoredClasses.add(this.myQualifiedName)) {
            return;
        }
        ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)descriptor.getPsiElement());
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() {
                IgnoreClassFix.this.myIgnoredClasses.remove(IgnoreClassFix.this.myQualifiedName);
                ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            }

            public void redo() {
                IgnoreClassFix.this.myIgnoredClasses.add(IgnoreClassFix.this.myQualifiedName);
                ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            }

            public boolean isGlobal() {
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/IgnoreClassFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

