/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BadExceptionDeclaredInspectionBase
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.Throwable", "java.lang.Exception", "java.lang.Error", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ClassCastException", "java.lang.ArrayIndexOutOfBoundsException");
    public boolean ignoreTestCases = false;
    public boolean ignoreLibraryOverrides = false;

    public BadExceptionDeclaredInspectionBase() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            for (String string : strings) {
                this.exceptions.add(string);
            }
            this.exceptionsString = "";
        }
    }

    @NotNull
    public String getID() {
        if ("ProhibitedExceptionDeclared" == null) {
            BadExceptionDeclaredInspectionBase.$$$reportNull$$$0(0);
        }
        return "ProhibitedExceptionDeclared";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.exception.declared.display.name", new Object[0]);
        if (string == null) {
            BadExceptionDeclaredInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.exception.declared.problem.descriptor", new Object[0]);
        if (string == null) {
            BadExceptionDeclaredInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionDeclaredVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/BadExceptionDeclaredInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class BadExceptionDeclaredVisitor
    extends BaseInspectionVisitor {
        private BadExceptionDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiJavaCodeReferenceElement[] references;
            if (method == null) {
                BadExceptionDeclaredVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (BadExceptionDeclaredInspectionBase.this.ignoreLibraryOverrides && LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
                PsiClass thrownClass;
                String qualifiedName;
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiClass) || (qualifiedName = (thrownClass = (PsiClass)element).getQualifiedName()) == null || !BadExceptionDeclaredInspectionBase.this.exceptions.contains(qualifiedName)) continue;
                this.registerError((PsiElement)reference, reference);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/errorhandling/BadExceptionDeclaredInspectionBase$BadExceptionDeclaredVisitor", "visitMethod"));
        }
    }
}

