/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageVisibleInnerClassInspectionBase
extends BaseInspection {
    public boolean ignoreEnums = false;
    public boolean ignoreInterfaces = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.visible.inner.class.display.name", new Object[0]);
        if (string == null) {
            PackageVisibleInnerClassInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("package.visible.inner.class.problem.descriptor", new Object[0]);
        if (string == null) {
            PackageVisibleInnerClassInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("package.visible.inner.class.ignore.enum.option", new Object[0]), "ignoreEnums");
        panel.addCheckbox(InspectionGadgetsBundle.message("package.visible.inner.class.ignore.interface.option", new Object[0]), "ignoreInterfaces");
        return panel;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageVisibleInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/encapsulation/PackageVisibleInnerClassInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PackageVisibleInnerClassVisitor
    extends BaseInspectionVisitor {
        private PackageVisibleInnerClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                PackageVisibleInnerClassVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected") || aClass.hasModifierProperty("private")) {
                return;
            }
            if (!ClassUtils.isInnerClass(aClass)) {
                return;
            }
            if (PackageVisibleInnerClassInspectionBase.this.ignoreEnums && aClass.isEnum()) {
                return;
            }
            if (PackageVisibleInnerClassInspectionBase.this.ignoreInterfaces && aClass.isInterface()) {
                return;
            }
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/encapsulation/PackageVisibleInnerClassInspectionBase$PackageVisibleInnerClassVisitor", "visitClass"));
        }
    }
}

