/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSwitchStatementWhichMissesCasesInspection
extends BaseInspection {
    public boolean ignoreSwitchStatementsWithDefault = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.display.name", new Object[0]);
        if (string == null) {
            EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String enumName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor", enumName);
        if (string == null) {
            EnumSwitchStatementWhichMissesCasesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchStatementsWithDefault");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumSwitchStatementWhichMissesCasesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EnumSwitchStatementWhichMissesCasesVisitor
    extends BaseInspectionVisitor {
        private EnumSwitchStatementWhichMissesCasesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                EnumSwitchStatementWhichMissesCasesVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            PsiExpression expression2 = statement.getExpression();
            if (expression2 == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            if (aClass == null || !aClass.isEnum()) {
                return;
            }
            int count = SwitchUtils.calculateBranchCount(statement);
            if (EnumSwitchStatementWhichMissesCasesInspection.this.ignoreSwitchStatementsWithDefault && count < 0) {
                return;
            }
            if (count == 0 || ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)aClass, Math.abs(count), PsiEnumConstant.class)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, aClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection$EnumSwitchStatementWhichMissesCasesVisitor", "visitSwitchStatement"));
        }
    }
}

