/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DuplicateBooleanBranchInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("duplicate.boolean.branch.display.name", new Object[0]);
        if (string == null) {
            DuplicateBooleanBranchInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("duplicate.boolean.branch.problem.descriptor", new Object[0]);
        if (string == null) {
            DuplicateBooleanBranchInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateBooleanBranchVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/DuplicateBooleanBranchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DuplicateBooleanBranchVisitor
    extends BaseInspectionVisitor {
        private DuplicateBooleanBranchVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiBinaryExpression parentExpression;
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiBinaryExpression && tokenType.equals((parentExpression = (PsiBinaryExpression)parent).getOperationTokenType())) {
                return;
            }
            SmartList conditions = new SmartList();
            DuplicateBooleanBranchVisitor.collectConditions((PsiExpression)expression2, (Collection<PsiExpression>)conditions, tokenType);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            PsiExpression[] conditionArray = conditions.toArray(new PsiExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                PsiExpression condition2 = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    if (matched[j]) continue;
                    PsiExpression testCondition = conditionArray[j];
                    boolean areEquivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(condition2, testCondition);
                    if (!areEquivalent) continue;
                    this.registerError((PsiElement)testCondition, new Object[0]);
                    if (!matched[i]) {
                        this.registerError((PsiElement)condition2, new Object[0]);
                    }
                    matched[i] = true;
                    matched[j] = true;
                }
            }
        }

        private static void collectConditions(PsiExpression condition2, Collection<PsiExpression> conditions, IElementType tokenType) {
            PsiPolyadicExpression polyadicExpression;
            IElementType testTokeType;
            if (condition2 == null) {
                return;
            }
            if (condition2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                DuplicateBooleanBranchVisitor.collectConditions(contents, conditions, tokenType);
                return;
            }
            if (condition2 instanceof PsiPolyadicExpression && (testTokeType = (polyadicExpression = (PsiPolyadicExpression)condition2).getOperationTokenType()).equals(tokenType)) {
                PsiExpression[] operands2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    DuplicateBooleanBranchVisitor.collectConditions(operand2, conditions, tokenType);
                }
                return;
            }
            conditions.add(condition2);
        }
    }
}

