/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuspiciousComparatorCompareInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.comparator.compare.display.name", new Object[0]);
        if (string == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("ComparatorMethodParameterNotUsed" == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(1);
        }
        return "ComparatorMethodParameterNotUsed";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousComparatorCompareVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SuspiciousComparatorCompareVisitor
    extends BaseInspectionVisitor {
        private SuspiciousComparatorCompareVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!MethodUtils.isComparatorCompare(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.check(method.getParameterList(), (PsiElement)method.getBody());
        }

        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            PsiClass functionalInterface = PsiUtil.resolveClassInType((PsiType)lambda2.getFunctionalInterfaceType());
            if (functionalInterface == null || !"java.util.Comparator".equals(functionalInterface.getQualifiedName()) || ControlFlowUtils.lambdaExpressionAlwaysThrowsException(lambda2)) {
                return;
            }
            this.check(lambda2.getParameterList(), lambda2.getBody());
        }

        private void check(PsiParameterList parameterList, PsiElement body2) {
            MethodContract contract;
            PsiMethod method;
            PsiStatement statement;
            if (body2 == null || parameterList.getParametersCount() != 2) {
                return;
            }
            if (body2 instanceof PsiExpression && ExpressionUtils.isZero((PsiExpression)body2)) {
                return;
            }
            if (body2 instanceof PsiCodeBlock && (statement = ControlFlowUtils.getOnlyStatementInBlock((PsiCodeBlock)body2)) instanceof PsiReturnStatement && ExpressionUtils.isZero(((PsiReturnStatement)statement).getReturnValue())) {
                return;
            }
            PsiMethodCallExpression soleCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2), PsiMethodCallExpression.class);
            if (soleCall != null && (method = soleCall.resolveMethod()) != null && (contract = (MethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodCallContracts(method, soleCall))) != null && contract.isTrivial() && contract.getReturnValue().isFail()) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.checkParameterList(parameters2, body2);
            this.checkReflexivity(parameters2, body2);
        }

        private void checkParameterList(PsiParameter[] parameters2, PsiElement context) {
            ParameterAccessVisitor visitor = new ParameterAccessVisitor(parameters2);
            context.accept((PsiElementVisitor)visitor);
            for (PsiParameter unusedParameter : visitor.getUnusedParameters()) {
                this.registerVariableError((PsiVariable)unusedParameter, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.parameter.not.used", new Object[0]));
            }
        }

        private void checkReflexivity(final PsiParameter[] parameters2, PsiElement body2) {
            StandardDataFlowRunner runner = new StandardDataFlowRunner(false, body2){

                @Override
                @NotNull
                protected DfaMemoryState createMemoryState() {
                    DfaMemoryState state = super.createMemoryState();
                    DfaVariableValue var1 = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameters2[0]);
                    DfaVariableValue var2 = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameters2[1]);
                    DfaValue condition2 = this.getFactory().createCondition(var1, DfaRelationValue.RelationType.EQ, var2);
                    state.applyCondition(condition2);
                    DfaMemoryState dfaMemoryState = state;
                    if (dfaMemoryState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return dfaMemoryState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$1", "createMemoryState"));
                }
            };
            ComparatorVisitor visitor = new ComparatorVisitor();
            if (runner.analyzeMethod(body2, visitor) != RunnerResult.OK) {
                return;
            }
            if (visitor.myRange.contains(0L)) {
                return;
            }
            PsiElement context = null;
            if (visitor.myContexts.size() == 1) {
                context = visitor.myContexts.iterator().next();
            } else {
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)body2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                if (parent instanceof PsiMethod) {
                    context = ((PsiMethod)parent).getNameIdentifier();
                } else if (parent instanceof PsiLambdaExpression) {
                    context = ((PsiLambdaExpression)parent).getParameterList();
                }
            }
            this.registerError(context != null ? context : body2, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.non.reflexive", new Object[0]));
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(@NotNull PsiParameter[] parameters2) {
                if (parameters2 == null) {
                    ParameterAccessVisitor.$$$reportNull$$$0(0);
                }
                this.parameters = new HashSet<PsiParameter>(Arrays.asList(parameters2));
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter2 = (PsiParameter)target;
                this.parameters.remove(parameter2);
                if (this.parameters.isEmpty()) {
                    this.stopWalking();
                }
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$ParameterAccessVisitor", "<init>"));
            }
        }

        private static class ComparatorVisitor
        extends StandardInstructionVisitor {
            LongRangeSet myRange = LongRangeSet.empty();
            Set<PsiElement> myContexts = new HashSet<PsiElement>();

            private ComparatorVisitor() {
            }

            @Override
            public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                this.myContexts.add((PsiElement)instruction.getReturn());
                DfaValue value2 = memState.peek();
                LongRangeSet range = memState.getValueFact(value2, DfaFactType.RANGE);
                this.myRange = range == null ? LongRangeSet.all() : this.myRange.union(range);
                return super.visitCheckReturnValue(instruction, runner, memState);
            }
        }
    }
}

