/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteSideEffectsAwareFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyStatementBodyInspection
extends BaseInspection {
    public boolean m_reportEmptyBlocks = true;
    public boolean commentsAreContent = false;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "m_reportEmptyBlocks").setAttribute("value", String.valueOf(this.m_reportEmptyBlocks)));
        if (this.commentsAreContent) {
            node.addContent(new Element("option").setAttribute("name", "commentsAreContent").setAttribute("value", "true"));
        }
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("StatementWithEmptyBody" == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(1);
        }
        return "StatementWithEmptyBody";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.display.name", new Object[0]);
        if (string == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("statement.with.empty.body.include.option", new Object[0]), "m_reportEmptyBlocks");
        panel.addCheckbox(InspectionGadgetsBundle.message("comments.as.content.option", new Object[0]), "commentsAreContent");
        return panel;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        LocalQuickFix fix = (LocalQuickFix)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])infos), LocalQuickFix.class);
        return fix == null ? null : new DelegatingFix(fix);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitDoWhileStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(2);
            }
            super.visitForStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(3);
            }
            super.visitForeachStatement(statement);
            this.checkLoopStatement((PsiLoopStatement)statement);
        }

        private void checkLoopStatement(PsiLoopStatement statement) {
            PsiStatement body2 = statement.getBody();
            if (body2 == null || !this.isEmpty((PsiElement)body2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(4);
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            if (thenBranch != null && this.isEmpty((PsiElement)thenBranch)) {
                LocalQuickFix fix = elseBranch == null || this.isEmpty((PsiElement)elseBranch) ? this.createFix((PsiStatement)statement, statement.getCondition()) : null;
                this.registerStatementError((PsiStatement)statement, fix);
                return;
            }
            if (elseBranch != null && this.isEmpty((PsiElement)elseBranch)) {
                PsiKeyword elseToken = statement.getElseElement();
                if (elseToken == null) {
                    return;
                }
                this.registerError((PsiElement)elseToken, new Object[]{new DeleteElementFix((PsiElement)elseBranch)});
            }
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            super.visitSwitchStatement(statement);
            PsiCodeBlock body2 = statement.getBody();
            if (body2 == null || !this.isEmpty((PsiElement)body2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, this.createFix((PsiStatement)statement, statement.getExpression()));
        }

        @NotNull
        private LocalQuickFix createFix(@NotNull PsiStatement statement, PsiExpression expression2) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(5);
            }
            if (expression2 == null) {
                DeleteElementFix deleteElementFix = new DeleteElementFix((PsiElement)statement);
                if (deleteElementFix == null) {
                    EmptyStatementVisitor.$$$reportNull$$$0(6);
                }
                return deleteElementFix;
            }
            DeleteSideEffectsAwareFix deleteSideEffectsAwareFix = new DeleteSideEffectsAwareFix(statement, expression2);
            if (deleteSideEffectsAwareFix == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(7);
            }
            return deleteSideEffectsAwareFix;
        }

        private boolean isEmpty(PsiElement element) {
            return ControlFlowUtils.isEmpty(element, EmptyStatementBodyInspection.this.commentsAreContent, EmptyStatementBodyInspection.this.m_reportEmptyBlocks);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDoWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForeachStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIfStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFix";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

