/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessBitwiseExpressionInspection
extends BaseInspection {
    public boolean m_ignoreExpressionsContainingConstants = true;
    static final Set<IElementType> bitwiseTokens = ContainerUtil.immutableSet((Object[])new IElementType[]{JavaTokenType.AND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT});

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.display.name", new Object[0]);
        if (string == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        String replacementExpression = this.calculateReplacementExpression(expression2, new CommentTracker());
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", replacementExpression);
        if (string == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    String calculateReplacementExpression(PsiExpression expression2, CommentTracker ct) {
        PsiExpression decremented;
        PsiPrefixExpression prefixExpression;
        if (expression2 instanceof PsiPolyadicExpression) {
            return this.calculateReplacementExpression((PsiPolyadicExpression)expression2, ct);
        }
        if (expression2 instanceof PsiPrefixExpression && (prefixExpression = (PsiPrefixExpression)expression2).getOperationTokenType().equals(JavaTokenType.TILDE) && (decremented = PointlessBitwiseExpressionInspection.extractDecrementedValue(prefixExpression.getOperand())) != null) {
            return "-" + ct.text(decremented, 3);
        }
        return "";
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression2, CommentTracker ct) {
        IElementType tokenType = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        PsiExpression previousOperand = null;
        int length = operands2.length;
        for (int i = 0; i < length; ++i) {
            PsiExpression operand2 = operands2[i];
            if (this.isZero(operand2)) {
                if (tokenType.equals(JavaTokenType.AND) || (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) && previousOperand == null) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)operands2[0], (PsiElement)operands2[length - 1], PsiType.LONG.equals((Object)expression2.getType()) ? "0L" : "0", ct);
                }
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.XOR) || (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) && previousOperand != null) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)(i == length - 1 ? expression2.getTokenBeforeOperand(operand2) : operand2), ct);
                }
            } else if (this.isAllOnes(operand2)) {
                if (tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)(i == length - 1 ? expression2.getTokenBeforeOperand(operand2) : operand2), ct);
                }
                if (tokenType.equals(JavaTokenType.OR)) {
                    return ct.text((PsiElement)operand2);
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    if (previousOperand != null) {
                        return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)previousOperand, (PsiElement)operand2, PointlessBitwiseExpressionInspection.getTildeReplacement(previousOperand, ct), ct);
                    }
                    PsiExpression nextOperand = operands2[i + 1];
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)operand2, (PsiElement)nextOperand, PointlessBitwiseExpressionInspection.getTildeReplacement(nextOperand, ct), ct);
                }
            } else if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousOperand, operand2)) {
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)previousOperand, (PsiElement)operand2, ct.text((PsiElement)operand2), ct);
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)previousOperand, (PsiElement)operand2, PsiType.LONG.equals((Object)expression2.getType()) ? "0L" : "0", ct);
                }
            }
            previousOperand = operand2;
        }
        return "";
    }

    private static String getTildeReplacement(PsiExpression operand2, CommentTracker ct) {
        PsiExpression decrementedValue = PointlessBitwiseExpressionInspection.extractDecrementedValue(operand2);
        if (decrementedValue != null) {
            return "-" + ct.text(decrementedValue, 3);
        }
        return "~" + ct.text(operand2, 3);
    }

    private static PsiExpression extractDecrementedValue(PsiExpression expression2) {
        Number right;
        PsiBinaryExpression binOp;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)expression2).getOperationTokenType().equals(JavaTokenType.MINUS) && ((right = JavaPsiMathUtil.getNumberFromLiteral(binOp.getROperand())) instanceof Integer || right instanceof Long) && right.longValue() == 1L) {
            return binOp.getLOperand();
        }
        return null;
    }

    private static String getText(PsiPolyadicExpression expression2, PsiElement fromTarget, PsiElement untilTarget, @NotNull @NonNls String replacement, CommentTracker ct) {
        if (replacement == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        boolean stop = false;
        for (PsiElement child : expression2.getChildren()) {
            if (child == fromTarget) {
                stop = true;
                result.append(replacement);
                continue;
            }
            if (child == untilTarget) {
                stop = false;
                continue;
            }
            if (child instanceof PsiComment || !stop) {
                result.append(ct.text(child));
                continue;
            }
            if (!(child instanceof PsiJavaToken) || untilTarget != null) continue;
            stop = false;
        }
        return result.toString();
    }

    private static String getText(PsiPolyadicExpression expression2, PsiElement exclude, CommentTracker ct) {
        return PointlessBitwiseExpressionInspection.getText(expression2, exclude, null, "", ct).trim();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression2 instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression2);
    }

    private boolean isAllOnes(PsiExpression expression2) {
        PsiType expressionType = expression2.getType();
        Object value2 = this.m_ignoreExpressionsContainingConstants ? JavaPsiMathUtil.getNumberFromLiteral(expression2) : ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)expressionType);
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Integer && (Integer)value2 == -1) {
            return true;
        }
        if (value2 instanceof Long && (Long)value2 == -1L) {
            return true;
        }
        if (value2 instanceof Short && (Short)value2 == -1) {
            return true;
        }
        if (value2 instanceof Character && ((Character)value2).charValue() == '\uffff') {
            return true;
        }
        return value2 instanceof Byte && (Byte)value2 == -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (expression2.getOperationTokenType().equals(JavaTokenType.TILDE) && PointlessBitwiseExpressionInspection.extractDecrementedValue(expression2.getOperand()) != null) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            PsiExpression[] operands2;
            if (expression2 == null) {
                PointlessBitwiseVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression2);
            IElementType sign = expression2.getOperationTokenType();
            if (!bitwiseTokens.contains(sign)) {
                return;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)expression2)) {
                return;
            }
            for (PsiExpression operand2 : operands2 = expression2.getOperands()) {
                if (operand2 == null) {
                    return;
                }
                PsiType type2 = operand2.getType();
                if (type2 != null && !type2.equals(PsiType.BOOLEAN) && !type2.equalsToText("java.lang.Boolean")) continue;
                return;
            }
            boolean isPointless = sign.equals(JavaTokenType.AND) || sign.equals(JavaTokenType.OR) || sign.equals(JavaTokenType.XOR) ? this.booleanExpressionIsPointless(operands2) : (sign.equals(JavaTokenType.LTLT) || sign.equals(JavaTokenType.GTGT) || sign.equals(JavaTokenType.GTGTGT) ? this.shiftExpressionIsPointless(operands2) : false);
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean booleanExpressionIsPointless(PsiExpression[] operands2) {
            PsiExpression previousExpression = null;
            for (PsiExpression operand2 : operands2) {
                if (PointlessBitwiseExpressionInspection.this.isZero(operand2) || PointlessBitwiseExpressionInspection.this.isAllOnes(operand2) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousExpression, operand2) && !SideEffectChecker.mayHaveSideEffects(operand2)) {
                    return true;
                }
                previousExpression = operand2;
            }
            return false;
        }

        private boolean shiftExpressionIsPointless(PsiExpression[] operands2) {
            for (PsiExpression operand2 : operands2) {
                if (!PointlessBitwiseExpressionInspection.this.isZero(operand2)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseVisitor", "visitPolyadicExpression"));
        }
    }

    private class PointlessBitwiseFix
    extends InspectionGadgetsFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            CommentTracker ct;
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionInspection.this.calculateReplacementExpression(expression2, ct = new CommentTracker());
            if (!newExpression.isEmpty()) {
                ct.replaceAndRestoreComments((PsiElement)expression2, newExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix", "getFamilyName"));
        }
    }
}

