/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PackageGroupingRule
extends DirectoryGroupingRule {
    public PackageGroupingRule(Project project) {
        super(project);
    }

    protected UsageGroup getGroupForFile(@NotNull VirtualFile dir) {
        PsiPackage aPackage;
        PsiDirectory psiDirectory;
        if (dir == null) {
            PackageGroupingRule.$$$reportNull$$$0(0);
        }
        if ((psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(dir)) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
            return new PackageGroup(aPackage);
        }
        return super.getGroupForFile(dir);
    }

    public String getActionTitle() {
        return UsageViewBundle.message((String)"action.group.by.package", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/usages/impl/rules/PackageGroupingRule", "getGroupForFile"));
    }

    private class PackageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final PsiPackage myPackage;
        private Icon myIcon;

        private PackageGroup(PsiPackage aPackage) {
            this.myPackage = aPackage;
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myIcon = this.myPackage.getIcon(0);
            }
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myPackage.getQualifiedName();
            if (string == null) {
                PackageGroup.$$$reportNull$$$0(0);
            }
            return string;
        }

        public FileStatus getFileStatus() {
            if (!this.isValid()) {
                return null;
            }
            PsiDirectory[] dirs = this.myPackage.getDirectories();
            return dirs.length == 1 ? FileStatusManager.getInstance((Project)PackageGroupingRule.this.myProject).getStatus(dirs[0].getVirtualFile()) : null;
        }

        public boolean isValid() {
            return this.myPackage.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            this.myPackage.navigate(focus);
        }

        public boolean canNavigate() {
            return this.myPackage.canNavigate();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                PackageGroup.$$$reportNull$$$0(1);
            }
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PackageGroup)) {
                return false;
            }
            return this.myPackage.equals(((PackageGroup)o).myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        public void calcData(DataKey key2, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key2) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)this.myPackage);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/PackageGroupingRule$PackageGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/PackageGroupingRule$PackageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

