/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestAction;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateTestDialog
extends DialogWrapper {
    private static final String RECENTS_KEY = "CreateTestDialog.RecentsKey";
    private static final String RECENT_SUPERS_KEY = "CreateTestDialog.Recents.Supers";
    private static final String DEFAULT_LIBRARY_NAME_PROPERTY = CreateTestDialog.class.getName() + ".defaultLibrary";
    private static final String DEFAULT_LIBRARY_SUPERCLASS_NAME_PROPERTY = CreateTestDialog.class.getName() + ".defaultLibrarySuperClass";
    private static final String SHOW_INHERITED_MEMBERS_PROPERTY = CreateTestDialog.class.getName() + ".includeInheritedMembers";
    private final Project myProject;
    private final PsiClass myTargetClass;
    private final PsiPackage myTargetPackage;
    private final Module myTargetModule;
    protected PsiDirectory myTargetDirectory;
    private TestFramework mySelectedFramework;
    private final ComboBox<TestFramework> myLibrariesCombo;
    private EditorTextField myTargetClassNameField;
    private ReferenceEditorComboWithBrowseButton mySuperClassField;
    private ReferenceEditorComboWithBrowseButton myTargetPackageField;
    private final JCheckBox myGenerateBeforeBox;
    private final JCheckBox myGenerateAfterBox;
    private final JCheckBox myShowInheritedMethodsBox;
    private final MemberSelectionTable myMethodsTable;
    private final JButton myFixLibraryButton;
    private JPanel myFixLibraryPanel;
    private JLabel myFixLibraryLabel;

    public CreateTestDialog(@NotNull Project project, @NotNull String title, PsiClass targetClass, PsiPackage targetPackage, Module targetModule) {
        if (project == null) {
            CreateTestDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            CreateTestDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myLibrariesCombo = new ComboBox(new DefaultComboBoxModel());
        this.myGenerateBeforeBox = new JCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.setUp", (Object[])new Object[0]));
        this.myGenerateAfterBox = new JCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.tearDown", (Object[])new Object[0]));
        this.myShowInheritedMethodsBox = new JCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.show.inherited", (Object[])new Object[0]));
        this.myMethodsTable = new MemberSelectionTable(Collections.emptyList(), null);
        this.myFixLibraryButton = new JButton(CodeInsightBundle.message((String)"intention.create.test.dialog.fix.library", (Object[])new Object[0]));
        this.myProject = project;
        this.myTargetClass = targetClass;
        this.myTargetPackage = targetPackage;
        this.myTargetModule = targetModule;
        this.setTitle(title);
        this.init();
    }

    protected String suggestTestClassName(PsiClass targetClass) {
        JavaCodeStyleSettings customSettings = JavaCodeStyleSettings.getInstance(targetClass.getContainingFile());
        String prefix = customSettings.TEST_NAME_PREFIX;
        String suffix = customSettings.TEST_NAME_SUFFIX;
        return prefix + targetClass.getName() + suffix;
    }

    private boolean isSuperclassSelectedManually() {
        String superClass = this.mySuperClassField.getText();
        if (StringUtil.isEmptyOrSpaces((String)superClass)) {
            return false;
        }
        for (TestFramework framework : (TestFramework[])TestFramework.EXTENSION_NAME.getExtensions()) {
            if (superClass.equals(framework.getDefaultSuperClass())) {
                return false;
            }
            if (!superClass.equals(this.getLastSelectedSuperClassName(framework))) continue;
            return false;
        }
        return true;
    }

    private void onLibrarySelected(TestFramework descriptor) {
        String superClass;
        if (descriptor.isLibraryAttached(this.myTargetModule)) {
            this.myFixLibraryPanel.setVisible(false);
        } else {
            this.myFixLibraryPanel.setVisible(true);
            String text2 = CodeInsightBundle.message((String)"intention.create.test.dialog.library.not.found", (Object[])new Object[]{descriptor.getName()});
            this.myFixLibraryLabel.setText(text2);
            this.myFixLibraryButton.setVisible(descriptor instanceof JavaTestFramework && ((JavaTestFramework)descriptor).getFrameworkLibraryDescriptor() != null || descriptor.getLibraryPath() != null);
        }
        String libraryDefaultSuperClass = descriptor.getDefaultSuperClass();
        String lastSelectedSuperClass = this.getLastSelectedSuperClassName(descriptor);
        String string = superClass = lastSelectedSuperClass != null ? lastSelectedSuperClass : libraryDefaultSuperClass;
        if (this.isSuperclassSelectedManually()) {
            if (superClass != null) {
                String currentSuperClass = this.mySuperClassField.getText();
                this.mySuperClassField.appendItem(superClass);
                this.mySuperClassField.setText(currentSuperClass);
            }
        } else {
            this.mySuperClassField.appendItem(StringUtil.notNullize((String)superClass));
            ((EditorComboBox)this.mySuperClassField.getChildComponent()).setSelectedItem((Object)StringUtil.notNullize((String)superClass));
        }
        this.mySelectedFramework = descriptor;
    }

    private void updateMethodsTable() {
        List<MemberInfo> methods = TestIntegrationUtils.extractClassMethods(this.myTargetClass, this.myShowInheritedMethodsBox.isSelected());
        HashSet<PsiElement> selectedMethods = new HashSet<PsiElement>();
        for (MemberInfo each : this.myMethodsTable.getSelectedMemberInfos()) {
            selectedMethods.add(each.getMember());
        }
        for (MemberInfo each : methods) {
            each.setChecked(selectedMethods.contains(each.getMember()));
        }
        this.myMethodsTable.setMemberInfos(methods);
    }

    private String getDefaultLibraryName() {
        return this.getProperties().getValue(DEFAULT_LIBRARY_NAME_PROPERTY);
    }

    private String getLastSelectedSuperClassName(TestFramework framework) {
        return this.getProperties().getValue(CreateTestDialog.getDefaultSuperClassPropertyName(framework));
    }

    private void saveDefaultLibraryNameAndSuperClass() {
        this.getProperties().setValue(DEFAULT_LIBRARY_NAME_PROPERTY, this.mySelectedFramework.getName());
        this.getProperties().setValue(CreateTestDialog.getDefaultSuperClassPropertyName(this.mySelectedFramework), this.mySuperClassField.getText());
    }

    private static String getDefaultSuperClassPropertyName(TestFramework framework) {
        return DEFAULT_LIBRARY_SUPERCLASS_NAME_PROPERTY + "." + framework.getName();
    }

    private void restoreShowInheritedMembersStatus() {
        this.myShowInheritedMethodsBox.setSelected(this.getProperties().getBoolean(SHOW_INHERITED_MEMBERS_PROPERTY));
    }

    private void saveShowInheritedMembersStatus() {
        this.getProperties().setValue(SHOW_INHERITED_MEMBERS_PROPERTY, this.myShowInheritedMethodsBox.isSelected());
    }

    private PropertiesComponent getProperties() {
        return PropertiesComponent.getInstance((Project)this.myProject);
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            CreateTestDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetClassNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 2;
        constr.anchor = 17;
        int gridy = 1;
        constr.insets = CreateTestDialog.insets(4);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        JLabel libLabel = new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.testing.library", (Object[])new Object[0]));
        libLabel.setLabelFor((Component)this.myLibrariesCombo);
        panel.add((Component)libLabel, constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        constr.gridwidth = 0;
        panel.add((Component)this.myLibrariesCombo, constr);
        this.myFixLibraryPanel = new JPanel(new BorderLayout());
        this.myFixLibraryLabel = new JLabel();
        this.myFixLibraryLabel.setIcon(AllIcons.Actions.IntentionBulb);
        this.myFixLibraryPanel.add((Component)this.myFixLibraryLabel, "Center");
        this.myFixLibraryPanel.add((Component)this.myFixLibraryButton, "East");
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        constr.gridx = 0;
        panel.add((Component)this.myFixLibraryPanel, constr);
        constr.gridheight = 1;
        constr.insets = CreateTestDialog.insets(6);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.class.name", (Object[])new Object[0])), constr);
        this.myTargetClassNameField = new EditorTextField(this.suggestTestClassName(this.myTargetClass));
        this.myTargetClassNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                CreateTestDialog.this.getOKAction().setEnabled(PsiNameHelper.getInstance((Project)CreateTestDialog.this.myProject).isIdentifier(CreateTestDialog.this.getClassName()));
            }
        });
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)this.myTargetClassNameField, constr);
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.super.class", (Object[])new Object[0])), constr);
        this.mySuperClassField = new ReferenceEditorComboWithBrowseButton(new MyChooseSuperClassAction(), null, this.myProject, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, RECENT_SUPERS_KEY);
        this.mySuperClassField.setMinimumSize(this.mySuperClassField.getPreferredSize());
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)((Object)this.mySuperClassField), constr);
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"dialog.create.class.destination.package.label", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        String targetPackageName = this.myTargetPackage != null ? this.myTargetPackage.getQualifiedName() : "";
        this.myTargetPackageField = new PackageNameReferenceEditorCombo(targetPackageName, this.myProject, RECENTS_KEY, CodeInsightBundle.message((String)"dialog.create.class.package.chooser.title", (Object[])new Object[0]));
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                CreateTestDialog.this.myTargetPackageField.getButton().doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myTargetPackageField.getChildComponent());
        JPanel targetPackagePanel = new JPanel(new BorderLayout());
        targetPackagePanel.add((Component)((Object)this.myTargetPackageField), "Center");
        panel.add((Component)targetPackagePanel, constr);
        constr.insets = CreateTestDialog.insets(6);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.generate", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)this.myGenerateBeforeBox, constr);
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        panel.add((Component)this.myGenerateAfterBox, constr);
        constr.insets = CreateTestDialog.insets(6);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        JLabel membersLabel = new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.select.methods", (Object[])new Object[0]));
        membersLabel.setLabelFor((Component)((Object)this.myMethodsTable));
        panel.add((Component)membersLabel, constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)this.myShowInheritedMethodsBox, constr);
        constr.insets = CreateTestDialog.insets(1, 8);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.gridwidth = 0;
        constr.fill = 1;
        constr.weighty = 1.0;
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myMethodsTable)), constr);
        this.myLibrariesCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<TestFramework>(){

            public void customize(JList list, TestFramework value2, int index, boolean selected, boolean hasFocus) {
                if (value2 != null) {
                    this.setText(value2.getName());
                    this.setIcon(value2.getIcon());
                }
            }
        });
        boolean hasTestRoots = !ModuleRootManager.getInstance((Module)this.myTargetModule).getSourceRoots(JavaModuleSourceRootTypes.TESTS).isEmpty();
        ArrayList<TestFramework> attachedLibraries = new ArrayList<TestFramework>();
        String defaultLibrary = this.getDefaultLibraryName();
        TestFramework defaultDescriptor = null;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myLibrariesCombo.getModel();
        SmartList descriptors = new SmartList(Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME));
        descriptors.sort((d1, d2) -> Comparing.compare((Comparable)((Object)d1.getName()), (Comparable)((Object)d2.getName())));
        for (TestFramework descriptor : descriptors) {
            model.addElement(descriptor);
            if (hasTestRoots && descriptor.isLibraryAttached(this.myTargetModule)) {
                attachedLibraries.add(descriptor);
                if (defaultLibrary == null) {
                    defaultDescriptor = descriptor;
                }
            }
            if (!Comparing.equal((String)defaultLibrary, (String)descriptor.getName())) continue;
            defaultDescriptor = descriptor;
        }
        this.myLibrariesCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = CreateTestDialog.this.myLibrariesCombo.getSelectedItem();
                if (selectedItem != null) {
                    DumbService dumbService = DumbService.getInstance((Project)CreateTestDialog.this.myProject);
                    dumbService.setAlternativeResolveEnabled(true);
                    try {
                        CreateTestDialog.this.onLibrarySelected((TestFramework)selectedItem);
                    }
                    finally {
                        dumbService.setAlternativeResolveEnabled(false);
                    }
                }
            }
        });
        if (defaultDescriptor != null && (attachedLibraries.contains(defaultDescriptor) || attachedLibraries.isEmpty())) {
            this.myLibrariesCombo.setSelectedItem((Object)defaultDescriptor);
        } else {
            this.myLibrariesCombo.setSelectedIndex(0);
        }
        this.myFixLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateTestDialog.this.mySelectedFramework instanceof JavaTestFramework) {
                    ((JavaTestFramework)CreateTestDialog.this.mySelectedFramework).setupLibrary(CreateTestDialog.this.myTargetModule);
                } else {
                    OrderEntryFix.addJarToRoots(CreateTestDialog.this.mySelectedFramework.getLibraryPath(), CreateTestDialog.this.myTargetModule, null);
                }
                CreateTestDialog.this.myFixLibraryPanel.setVisible(false);
            }
        });
        this.myShowInheritedMethodsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateTestDialog.this.updateMethodsTable();
            }
        });
        this.restoreShowInheritedMembersStatus();
        this.updateMethodsTable();
        return panel;
    }

    private static Insets insets(int top) {
        return CreateTestDialog.insets(top, 0);
    }

    private static Insets insets(int top, int bottom) {
        return JBUI.insets((int)top, (int)8, (int)bottom, (int)8);
    }

    public String getClassName() {
        return this.myTargetClassNameField.getText();
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    @Nullable
    public String getSuperClassName() {
        String result = this.mySuperClassField.getText().trim();
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public Collection<MemberInfo> getSelectedMethods() {
        return this.myMethodsTable.getSelectedMemberInfos();
    }

    public boolean shouldGeneratedAfter() {
        return this.myGenerateAfterBox.isSelected();
    }

    public boolean shouldGeneratedBefore() {
        return this.myGenerateBeforeBox.isSelected();
    }

    public TestFramework getSelectedTestFrameworkDescriptor() {
        return this.mySelectedFramework;
    }

    protected void doOKAction() {
        int result;
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, this.myTargetPackageField.getText());
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_SUPERS_KEY, this.mySuperClassField.getText());
        String errorMessage = null;
        try {
            this.myTargetDirectory = this.selectTargetDirectory();
            if (this.myTargetDirectory == null) {
                return;
            }
        }
        catch (IncorrectOperationException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage == null) {
            try {
                errorMessage = this.checkCanCreateClass();
            }
            catch (IncorrectOperationException e) {
                errorMessage = e.getMessage();
            }
        }
        if (errorMessage != null && (result = Messages.showOkCancelDialog((Project)this.myProject, (String)(errorMessage + ". Update existing class?"), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon())) == 2) {
            return;
        }
        this.saveDefaultLibraryNameAndSuperClass();
        this.saveShowInheritedMembersStatus();
        super.doOKAction();
    }

    protected String checkCanCreateClass() {
        return RefactoringMessageUtil.checkCanCreateClass(this.myTargetDirectory, this.getClassName());
    }

    @Nullable
    private PsiDirectory selectTargetDirectory() throws IncorrectOperationException {
        String packageName = this.getPackageName();
        PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName);
        VirtualFile selectedRoot = (VirtualFile)ReadAction.compute(() -> {
            ArrayList<Object> roots;
            List<VirtualFile> testFolders = CreateTestAction.computeTestRoots(this.myTargetModule);
            if (testFolders.isEmpty()) {
                roots = new ArrayList();
                List<String> urls = CreateTestAction.computeSuitableTestRootUrls(this.myTargetModule);
                for (String url : urls) {
                    try {
                        ContainerUtil.addIfNotNull(roots, (Object)VfsUtil.createDirectories((String)VfsUtilCore.urlToPath((String)url)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (roots.isEmpty()) {
                    JavaProjectRootsUtil.collectSuitableDestinationSourceRoots(this.myTargetModule, roots);
                }
                if (roots.isEmpty()) {
                    return null;
                }
            } else {
                roots = new ArrayList<VirtualFile>(testFolders);
            }
            if (roots.size() == 1) {
                return (VirtualFile)roots.get(0);
            }
            PsiDirectory defaultDir = this.chooseDefaultDirectory(targetPackage.getDirectories(), roots);
            return MoveClassesOrPackagesUtil.chooseSourceRoot(targetPackage, roots, defaultDir);
        });
        if (selectedRoot == null) {
            return null;
        }
        return (PsiDirectory)WriteCommandAction.writeCommandAction((Project)this.myProject).withName(CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0])).compute(() -> RefactoringUtil.createPackageDirectoryInSourceRoot(targetPackage, selectedRoot));
    }

    @Nullable
    private PsiDirectory chooseDefaultDirectory(PsiDirectory[] directories, List<VirtualFile> roots) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : ModuleRootManager.getInstance((Module)this.myTargetModule).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            PsiDirectory dir = psiManager.findDirectory(file);
            if (dir == null) continue;
            dirs.add(dir);
        }
        if (!dirs.isEmpty()) {
            for (PsiDirectory dir : dirs) {
                String dirName = dir.getVirtualFile().getPath();
                if (dirName.contains("generated")) continue;
                return dir;
            }
            return (PsiDirectory)dirs.get(0);
        }
        for (PsiDirectory dir : directories) {
            VirtualFile file = dir.getVirtualFile();
            for (VirtualFile root2 : roots) {
                PsiDirectory rootDir;
                if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)file, (boolean)false) || (rootDir = psiManager.findDirectory(root2)) == null) continue;
                return rootDir;
            }
        }
        return ModuleManager.getInstance((Project)this.myProject).getModuleDependentModules(this.myTargetModule).stream().flatMap(module -> ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE).stream()).map(root -> psiManager.findDirectory(root)).findFirst().orElse(null);
    }

    private String getPackageName() {
        String name = this.myTargetPackageField.getText();
        return name != null ? name.trim() : "";
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.dialogs.createTest");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/createTest/CreateTestDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/createTest/CreateTestDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChooseSuperClassAction
    implements ActionListener {
        private MyChooseSuperClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory f = TreeClassChooserFactory.getInstance((Project)CreateTestDialog.this.myProject);
            TreeClassChooser dialog = f.createAllProjectScopeChooser(CodeInsightBundle.message((String)"intention.create.test.dialog.choose.super.class", (Object[])new Object[0]));
            dialog.showDialog();
            PsiClass aClass = dialog.getSelected();
            if (aClass != null) {
                String superClass = aClass.getQualifiedName();
                CreateTestDialog.this.mySuperClassField.appendItem(superClass);
                ((EditorComboBox)CreateTestDialog.this.mySuperClassField.getChildComponent()).setSelectedItem((Object)superClass);
            }
        }
    }
}

