/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGenerateTestSupportMethodAction
extends BaseGenerateAction {
    protected static final Logger LOG = Logger.getInstance(BaseGenerateTestSupportMethodAction.class);

    public BaseGenerateTestSupportMethodAction(TestIntegrationUtils.MethodKind methodKind) {
        super((CodeInsightActionHandler)new MyHandler(methodKind));
    }

    @Nullable
    public AnAction createEditTemplateAction(DataContext dataContext) {
        PsiClass targetClass;
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiClass psiClass = targetClass = editor == null || file == null ? null : this.getTargetClass(editor, file);
        if (targetClass != null) {
            final List<TestFramework> frameworks = TestIntegrationUtils.findSuitableFrameworks(targetClass);
            final TestIntegrationUtils.MethodKind methodKind = ((MyHandler)this.getHandler()).myMethodKind;
            if (!frameworks.isEmpty()) {
                return new AnAction("Edit Template"){

                    public void actionPerformed(AnActionEvent e) {
                        BaseGenerateTestSupportMethodAction.chooseAndPerform(editor, frameworks, (Consumer<TestFramework>)framework -> {
                            FileTemplateDescriptor descriptor = methodKind.getFileTemplateDescriptor((TestFramework)framework);
                            if (descriptor != null) {
                                String fileName = descriptor.getFileName();
                                AllFileTemplatesConfigurable.editCodeTemplate((String)FileUtil.getNameWithoutExtension((String)fileName), (Project)project);
                            } else {
                                HintManager.getInstance().showErrorHint(editor, "No template found for " + framework.getName() + ":" + BaseGenerateTestSupportMethodAction.this.getTemplatePresentation().getText());
                            }
                        });
                    }
                };
            }
        }
        return null;
    }

    protected PsiClass getTargetClass(Editor editor, PsiFile file) {
        return BaseGenerateTestSupportMethodAction.findTargetClass(editor, file);
    }

    @Nullable
    private static PsiClass findTargetClass(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement element;
        PsiClass containingClass;
        if (editor == null) {
            BaseGenerateTestSupportMethodAction.$$$reportNull$$$0(0);
        }
        if (file == null) {
            BaseGenerateTestSupportMethodAction.$$$reportNull$$$0(1);
        }
        if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(offset = editor.getCaretModel().getOffset())), PsiClass.class, (boolean)false)) == null) {
            return null;
        }
        List<TestFramework> frameworks = TestIntegrationUtils.findSuitableFrameworks(containingClass);
        for (TestFramework framework : frameworks) {
            if (!(framework instanceof JavaTestFramework) || !((JavaTestFramework)framework).acceptNestedClasses()) continue;
            return containingClass;
        }
        return TestIntegrationUtils.findOuterClass(element);
    }

    protected boolean isValidForClass(PsiClass targetClass) {
        List<TestFramework> frameworks = TestIntegrationUtils.findSuitableFrameworks(targetClass);
        if (frameworks.isEmpty()) {
            return false;
        }
        for (TestFramework each : frameworks) {
            if (!this.isValidFor(targetClass, each)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            BaseGenerateTestSupportMethodAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            BaseGenerateTestSupportMethodAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            BaseGenerateTestSupportMethodAction.$$$reportNull$$$0(4);
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        PsiClass targetClass = this.getTargetClass(editor, file);
        return targetClass != null && this.isValidForClass(targetClass);
    }

    protected boolean isValidFor(PsiClass targetClass, TestFramework framework) {
        return true;
    }

    private static void chooseAndPerform(Editor editor, List<TestFramework> frameworks, Consumer<TestFramework> consumer) {
        if (frameworks.size() == 1) {
            consumer.consume((Object)frameworks.get(0));
            return;
        }
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
                if (value2 == null) {
                    return result;
                }
                TestFramework framework = (TestFramework)value2;
                this.setIcon(framework.getIcon());
                this.setText(framework.getName());
                return result;
            }
        };
        JBPopupFactory.getInstance().createPopupChooserBuilder(frameworks).setRenderer((ListCellRenderer)cellRenderer).setNamerForFiltering(o -> o.getName()).setTitle("Choose Framework").setItemChosenCallback(selectedValue -> consumer.consume(selectedValue)).setMovable(true).createPopup().showInBestPositionFor(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyHandler
    implements CodeInsightActionHandler {
        private final TestIntegrationUtils.MethodKind myMethodKind;

        public MyHandler(TestIntegrationUtils.MethodKind methodKind) {
            this.myMethodKind = methodKind;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if (file == null) {
                MyHandler.$$$reportNull$$$0(2);
            }
            PsiClass targetClass = BaseGenerateTestSupportMethodAction.findTargetClass(editor, file);
            ArrayList<TestFramework> frameworks = new ArrayList<TestFramework>(TestIntegrationUtils.findSuitableFrameworks(targetClass));
            Iterator iterator = frameworks.iterator();
            while (iterator.hasNext()) {
                if (this.myMethodKind.getFileTemplateDescriptor((TestFramework)iterator.next()) != null) continue;
                iterator.remove();
            }
            if (frameworks.isEmpty()) {
                return;
            }
            Consumer consumer = framework -> {
                if (editor == null) {
                    MyHandler.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    MyHandler.$$$reportNull$$$0(4);
                }
                if (framework == null) {
                    return;
                }
                this.doGenerate(editor, file, targetClass, (TestFramework)framework);
            };
            BaseGenerateTestSupportMethodAction.chooseAndPerform(editor, frameworks, (Consumer<TestFramework>)consumer);
        }

        private void doGenerate(Editor editor, PsiFile file, PsiClass targetClass, TestFramework framework) {
            if (framework instanceof JavaTestFramework && ((JavaTestFramework)framework).isSingleConfig()) {
                PsiElement alreadyExist = null;
                switch (this.myMethodKind) {
                    case SET_UP: {
                        alreadyExist = framework.findSetUpMethod((PsiElement)targetClass);
                        break;
                    }
                    case TEAR_DOWN: {
                        alreadyExist = framework.findTearDownMethod((PsiElement)targetClass);
                        break;
                    }
                }
                if (alreadyExist instanceof PsiMethod) {
                    editor.getCaretModel().moveToOffset(alreadyExist.getNavigationElement().getTextOffset());
                    HintManager.getInstance().showErrorHint(editor, "Method " + ((PsiMethod)alreadyExist).getName() + " already exists");
                    return;
                }
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> {
                try {
                    PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
                    PsiMethod method = MyHandler.generateDummyMethod(file, editor, targetClass);
                    if (method == null) {
                        return;
                    }
                    TestIntegrationUtils.runTestMethodTemplate(this.myMethodKind, framework, editor, targetClass, method, "name", false, null);
                }
                catch (IncorrectOperationException e) {
                    HintManager.getInstance().showErrorHint(editor, "Cannot generate method: " + e.getMessage());
                    LOG.warn((Throwable)e);
                }
            });
        }

        @Nullable
        private static PsiMethod generateDummyMethod(PsiFile file, Editor editor, PsiClass targetClass) throws IncorrectOperationException {
            PsiMethod method = TestIntegrationUtils.createDummyMethod((PsiElement)file);
            PsiGenerationInfo<PsiMethod> info = OverrideImplementUtil.createGenerationInfo(method);
            int offset = MyHandler.findOffsetToInsertMethodTo(editor, file, targetClass);
            GenerateMembersUtil.insertMembersAtOffset(file, offset, Collections.singletonList(info));
            PsiMethod member = info.getPsiMember();
            return member != null ? (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)member) : null;
        }

        private static int findOffsetToInsertMethodTo(Editor editor, PsiFile file, PsiClass targetClass) {
            int result = editor.getCaretModel().getOffset();
            PsiClass classAtCursor = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(result), PsiClass.class, (boolean)false);
            if (classAtCursor == targetClass) {
                return result;
            }
            while (classAtCursor != null && !(classAtCursor.getParent() instanceof PsiFile)) {
                result = classAtCursor.getTextRange().getEndOffset();
                classAtCursor = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)classAtCursor, PsiClass.class);
            }
            return result;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction$MyHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$invoke$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

